/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.mudhut.ffpackage.level.block.PosterBlock;
import net.mudhut.ffpackage.level.item.CPUItem;
import net.mudhut.ffpackage.level.item.EndoSpawnerItem;
import net.mudhut.ffpackage.level.item.FazWrenchItem;
import net.mudhut.ffpackage.level.item.SodaItem;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPEntitiesRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.text.WordUtils;

public class FFPLanguageProvider
extends LanguageProvider {
    public FFPLanguageProvider(PackOutput output) {
        super(output, "ffpackage", "en_us");
    }

    protected void addTranslations() {
        for (DeferredHolder registry : FFPBlockRegistry.BLOCKS.getEntries()) {
            this.add((Block)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("_", " ")));
        }
        for (DeferredHolder registry : FFPPizzeriaBlocks.BLOCKS.getEntries()) {
            this.add((Block)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("_", " ")));
        }
        for (DeferredHolder registry : FFPDecorBlockRegistry.BLOCKS.getEntries()) {
            Object object = registry.get();
            if (object instanceof PosterBlock) {
                PosterBlock posterBlock = (PosterBlock)((Object)object);
                this.add((Block)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace(posterBlock.getModelName(), "'" + posterBlock.getPosterName() + "' ").replace("_", "")));
                continue;
            }
            this.add((Block)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("_", " ")));
        }
        for (DeferredHolder registry : FFPItemRegistry.ITEMS.getEntries()) {
            if (registry.get() instanceof EndoSpawnerItem) {
                this.add((Item)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("endo_", "Endo-").replace("_", " ")));
                continue;
            }
            if (registry.get() instanceof FazWrenchItem) {
                this.add((Item)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("faz_", "Faz-").replace("_", " ")));
                continue;
            }
            if (registry.get() instanceof CPUItem) {
                this.add((Item)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("cpu", "CPU").replace("_", " ")));
                continue;
            }
            if (registry.get() instanceof SodaItem || registry.is(FFPItemRegistry.BUCKET_OF_CHEESE)) continue;
            if (registry.is(FFPItemRegistry.CLASSIC_MR_CUPCAKE)) {
                this.add((Item)registry.get(), "Classic Mr. Cupcake");
                continue;
            }
            if (registry.is(FFPItemRegistry.DAISY_BELL_DISC)) {
                this.add((Item)registry.get(), "Music Disc");
                continue;
            }
            if (registry.is(FFPItemRegistry.FAZ_TICKET)) {
                this.add((Item)registry.get(), "Faz-Ticket");
                continue;
            }
            if (registry.is(FFPItemRegistry.FAZ_TOKEN)) {
                this.add((Item)registry.get(), "Faz-Token");
                continue;
            }
            if (registry.get() instanceof BlockItem) continue;
            this.add((Item)registry.get(), WordUtils.capitalize((String)registry.getId().getPath().replace("_", " ")));
        }
        for (DeferredHolder registry : FFPEntitiesRegistry.ENTITIES.getEntries()) {
            String name = ((EntityType)registry.get()).toShortString().replace("_", " ");
            if (name.contains(" ")) {
                this.add((EntityType)registry.get(), ((EntityType)registry.get()).toShortString().replace("_", "-"));
                continue;
            }
            this.add((EntityType)registry.get(), WordUtils.capitalize((String)name));
        }
        this.add("item.ffpackage.tomato_seeds", "Tomato Seeds");
        this.add("item.ffpackage.bucket_of_cheese", "Bucket of Cheese");
        this.add("item.ffpackage.cup_of_fizzy_faz", "Cup of Fizzy Faz");
        this.add("item.ffpackage.cup_of_chica_chug", "Cup of Chica Chug");
        this.add("item.ffpackage.cup_of_foxy_cove_cooler", "Cup of Foxy Cove Cooler");
        this.add("item.ffpackage.cup_of_exotic_beverage", "Cup of Exotic Beverage");
        this.add("item.ffpackage.cup_of_sodaroni", "Cup of Sodaroni");
        this.add("itemGroup.ffpackage.items", "FFPackage Items");
        this.add("itemGroup.ffpackage.pizzeria_blocks", "FFPackage Pizzeria Blocks");
        this.add("itemGroup.ffpackage.decor_blocks", "FFPackage Decor Blocks");
        this.add("ffpackage.title.mod_name", "Minecraft : Fazbear Franchise Package");
        this.add("ffpackage.config.custom_title_screen", "Toggle Custom Title Screen");
        this.add("ffpackage.config.title_screen_left", "Toggle Title Screen Button Side");
        this.add("ffpackage.config.warning_screen", "Toggle the Warning Screen");
        this.add("ffpackage.configuration.main_menu", "Main Menu Config");
        this.add("ffpackage.configuration.client_config", "FFPackage Client Config");
        this.add("ffpackage.warning_screen.warning", "WARNING!");
        this.add("ffpackage.warning_screen.warning_text", "This mod contains flashing lights, loud");
        this.add("ffpackage.warning_screen.warning_text2", "noises, and lots of jumpscares!");
        this.add("jukebox_song.ffpackage.daisy_bell", "Harry Dacre - Daisy Bell");
        this.add("menu.ffpackage.showtape_player", "Showtape Player");
        this.add("key.category.ffpackage", "Fazbear Franchise Package");
        this.add("key.ffpackage.crawl", "Crawling");
        this.add("death.attack.ffpackage.stuffed_in_suit", "%1$s was stuffed in a Freddy Fazbear suit");
        this.add("death.attack.ffpackage.stuffed_in_suit.player", "%1$s was stuffed in a Freddy Fazbear suit while fighting %2$s");
    }
}

