/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.registries.FFPSounds;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FFPSoundProvider
extends SoundDefinitionsProvider {
    protected FFPSoundProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "ffpackage", helper);
    }

    public void registerSounds() {
        for (DeferredHolder registry : FFPSounds.SOUND_EVENT.getEntries()) {
            if (registry.is(FFPSounds.ENDO_WALK)) {
                this.addSound((DeferredHolder<SoundEvent, ? extends SoundEvent>)registry, this.create("entity/endo/endo_01_footstep_1"), this.create("entity/endo/endo_01_footstep_2"), this.create("entity/endo/endo_01_footstep_3"));
                continue;
            }
            this.addSound((DeferredHolder<SoundEvent, ? extends SoundEvent>)registry, this.create(registry.getId().getPath().replace(".", "/")));
        }
    }

    private void addSound(DeferredHolder<SoundEvent, ? extends SoundEvent> soundEvent, SoundDefinition.Sound ... sounds) {
        SoundDefinition definition = SoundDefinition.definition();
        definition.with(sounds);
        this.add(soundEvent.getId(), definition);
    }

    private SoundDefinition.Sound create(String path) {
        return FFPSoundProvider.sound((ResourceLocation)FFPackage.resource(path));
    }
}

