/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalBlock;
import net.refractionapi.refraction.helper.voxels.VoxelUtil;

public class CurtainBlock
extends BaseHorizontalBlock {
    public static final VoxelShape[] SHAPE = VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));

    public CurtainBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)level, pos) ? super.updateShape(state, direction, neighborState, level, pos, neighborPos) : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(Direction.UP);
        return FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)level, (BlockPos)pos, (Direction)direction.getOpposite()) || FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)level, (BlockPos)pos, (Direction)Direction.DOWN.getOpposite()) || level.getBlockState(blockPos).getBlock() instanceof CurtainBlock;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }
}

