/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.WallHangingDecorBlock;

public abstract class HangingChainBlock
extends WallHangingDecorBlock {
    public HangingChainBlock(VoxelShape[] voxelShapes, BlockBehaviour.Properties pProperties) {
        super(voxelShapes, false, pProperties);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.relative(Direction.UP)).isAir();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.DOWN && !neighborState.is((Block)this) && !neighborState.is(this.getHeadBlock())) {
            return (BlockState)this.getHeadBlock().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public abstract Block getHeadBlock();

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getHeadBlock().asItem().getDefaultInstance();
    }
}

