/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.mudhut.ffpackage.level.block.DirectionalBlock;
import net.mudhut.ffpackage.util.FFPVoxelShapes;

public class MangroveEntranceDoorBlock
extends DirectionalBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    public MangroveEntranceDoorBlock(BlockBehaviour.Properties pProperties) {
        super(FFPVoxelShapes.DOOR, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 10);
        this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
        level.gameEvent((Entity)player, (Holder)(this.isOpen(state) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(entity, level, pos, open);
            level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
    }

    private void playSound(@Nullable Entity source, Level level, BlockPos pos, boolean isOpening) {
        level.playSound(source, pos, isOpening ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN});
    }
}

