/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.entity.MidnightMotorMachineBlockEntity;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalEntityBlock;
import net.refractionapi.refraction.helper.voxels.VoxelUtil;
import org.jetbrains.annotations.Nullable;

public class MidnightMotorMachineBlock
extends BaseHorizontalEntityBlock {
    public static final VoxelShape[] SHAPE = VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0));

    public MidnightMotorMachineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof MidnightMotorMachineBlockEntity) {
            MidnightMotorMachineBlockEntity MMblockEntity = (MidnightMotorMachineBlockEntity)blockEntity;
            MMblockEntity.drops();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity entity;
        if (!level.isClientSide && (entity = level.getBlockEntity(pos)) instanceof MidnightMotorMachineBlockEntity) {
            MidnightMotorMachineBlockEntity blockEntity = (MidnightMotorMachineBlockEntity)entity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity, (Component)Component.empty()), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MidnightMotorMachineBlockEntity(blockPos, blockState);
    }
}

