/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.registries.FFPItemRegistry;

public class PizzaBlock
extends Block {
    public static final MapCodec<PizzaBlock> CODEC = PizzaBlock.simpleCodec(PizzaBlock::new);
    public static final IntegerProperty SLICES = IntegerProperty.create((String)"slices", (int)0, (int)3);
    public static final VoxelShape[] SHAPE_BY_SLICES = new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Shapes.join((VoxelShape)Block.box((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)8.0, (double)8.0, (double)1.0, (double)14.0), (BooleanOp)BooleanOp.OR), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0)};

    public MapCodec<PizzaBlock> codec() {
        return CODEC;
    }

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SLICES, (Comparable)Integer.valueOf(3)));
    }

    public ItemStack getPizzaSliceItem() {
        return new ItemStack((ItemLike)FFPItemRegistry.PEPPERONI_PIZZA_SLICE.asItem(), 2);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)SLICES) == 0) {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            player.addItem(this.getPizzaSliceItem());
            player.playSound(SoundEvents.ITEM_PICKUP);
            return InteractionResult.SUCCESS;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)SLICES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)SLICES) - 1)), 3);
        player.addItem(this.getPizzaSliceItem());
        player.playSound(SoundEvents.ITEM_PICKUP);
        return InteractionResult.SUCCESS;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_SLICES[(Integer)state.getValue((Property)SLICES)];
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.below()).isAir();
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return PizzaBlock.getOutputSignal((Integer)blockState.getValue((Property)SLICES));
    }

    public static int getOutputSignal(int taken) {
        return (5 + taken) * 2;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLICES});
    }
}

