/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.entity.ShowtapePlayerBlockEntity;
import net.mudhut.ffpackage.level.item.components.FazWrenchComponent;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalEntityBlock;
import org.jetbrains.annotations.Nullable;

public class ShowtapePlayerBlock
extends BaseHorizontalEntityBlock {
    public ShowtapePlayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return FFPVoxelShapes.SHOWTAPE_PLAYER[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ShowtapePlayerBlockEntity) {
            ShowtapePlayerBlockEntity showtapePlayerBlockEntity = (ShowtapePlayerBlockEntity)blockEntity;
            showtapePlayerBlockEntity.drops();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(FFPItemRegistry.FAZ_WRENCH)) {
            level.playSound(player, pos, SoundEvents.BREEZE_CHARGE, SoundSource.NEUTRAL);
            player.getItemInHand(hand).set((DataComponentType)FFPDataComponents.FAZ_WRENCH.value(), (Object)new FazWrenchComponent(pos.getCenter().toVector3f()));
            FFPackage.LOGGER.info("{}", player.getItemInHand(hand).get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value()));
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity entity;
        if (!level.isClientSide && !player.getMainHandItem().is(FFPItemRegistry.FAZ_WRENCH) && (entity = level.getBlockEntity(pos)) instanceof ShowtapePlayerBlockEntity) {
            ShowtapePlayerBlockEntity showtapePlayerBlockEntity = (ShowtapePlayerBlockEntity)entity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)showtapePlayerBlockEntity, (Component)Component.empty()), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ShowtapePlayerBlockEntity(blockPos, blockState);
    }
}

