/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.mudhut.ffpackage.level.block.DirectionalBlock;
import net.mudhut.ffpackage.level.entity.ChairEntity;
import net.mudhut.ffpackage.registries.FFPEntitiesRegistry;
import net.mudhut.ffpackage.util.FFPVoxelShapes;

public class SittableBlock
extends DirectionalBlock {
    public SittableBlock(BlockBehaviour.Properties pProperties) {
        super(FFPVoxelShapes.STARRED_BLACK_CHAIR, pProperties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ChairEntity chairEntity = (ChairEntity)((EntityType)FFPEntitiesRegistry.CHAIR.get()).create(level);
        if (chairEntity != null) {
            chairEntity.setYRot(((Direction)state.getValue((Property)FACING)).toYRot());
            chairEntity.setPos((float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f);
            level.addFreshEntity((Entity)chairEntity);
            if (!chairEntity.hasPassenger((Entity)player)) {
                player.startRiding((Entity)chairEntity);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.relative(Direction.DOWN)).isAir();
    }
}

