/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.entity.SodaMachineBlockEntity;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalEntityBlock;
import net.refractionapi.refraction.helper.voxels.VoxelUtil;
import org.jetbrains.annotations.Nullable;

public class SodaMachineBlock
extends BaseHorizontalEntityBlock {
    public static final MapCodec<SodaMachineBlock> CODEC = SodaMachineBlock.simpleCodec(SodaMachineBlock::new);
    public static final VoxelShape[] SHAPE = VoxelUtil.makeHorizontalShapes((VoxelShape)Stream.of(Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)5.0), Block.box((double)11.0, (double)8.0, (double)1.0, (double)16.0, (double)14.0, (double)5.0), Block.box((double)12.0, (double)6.0, (double)1.5, (double)15.0, (double)8.0, (double)4.5), Block.box((double)6.5, (double)6.0, (double)1.5, (double)9.5, (double)8.0, (double)4.5), Block.box((double)1.0, (double)6.0, (double)1.5, (double)4.0, (double)8.0, (double)4.5), Block.box((double)5.0, (double)8.0, (double)1.0, (double)11.0, (double)14.0, (double)5.0), Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)8.0, (double)1.0, (double)5.0, (double)14.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get());

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public SodaMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof SodaMachineBlockEntity) {
            SodaMachineBlockEntity sodaMachineBlockEntity = (SodaMachineBlockEntity)blockEntity;
            sodaMachineBlockEntity.drops();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity entity;
        if (!level.isClientSide && (entity = level.getBlockEntity(pos)) instanceof SodaMachineBlockEntity) {
            SodaMachineBlockEntity sodaMachineEntity = (SodaMachineBlockEntity)entity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)sodaMachineEntity, (Component)Component.empty()), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SodaMachineBlockEntity(blockPos, blockState);
    }
}

