/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.inventory.MidnightMotoristMachineMenu;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.Nullable;

public class MidnightMotorMachineBlockEntity
extends BaseEntityBlock
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MidnightMotorMachineBlockEntity.this.setChanged();
            if (!MidnightMotorMachineBlockEntity.this.level.isClientSide()) {
                MidnightMotorMachineBlockEntity.this.level.sendBlockUpdated(MidnightMotorMachineBlockEntity.this.getBlockPos(), MidnightMotorMachineBlockEntity.this.getBlockState(), MidnightMotorMachineBlockEntity.this.getBlockState(), 2);
            }
        }
    };
    protected final ContainerData data = new ContainerData(this){

        public int get(int i) {
            return 2;
        }

        public void set(int i, int i1) {
        }

        public int getCount() {
            return 2;
        }
    };
    public boolean isGameActive = false;
    public boolean isGameWon = false;
    public int fazTicketCount = 0;

    public MidnightMotorMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.MM_MACHINE_BE.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.level == null) {
            return;
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public void tick() {
        if (this.isGameActive) {
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        ItemStack itemStack = this.itemHandler.getStackInSlot(1);
        if (this.isGameWon) {
            ItemStack fazTickets = ((Item)FFPItemRegistry.FAZ_TICKET.get()).getDefaultInstance();
            this.itemHandler.setStackInSlot(1, fazTickets);
            if (this.tickCount % 20 == 0) {
                ++this.fazTicketCount;
                fazTickets.setCount(fazTickets.getCount() + 1);
                this.itemHandler.setStackInSlot(1, fazTickets);
            }
        }
        if (this.fazTicketCount >= 5 || itemStack.getCount() == 0) {
            this.fazTicketCount = 0;
        }
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new MidnightMotoristMachineMenu(containerId, playerInventory, (BlockEntity)this, this.data);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

