/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.inventory.ShowtapePlayerMenu;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.mudhut.ffpackage.registries.FFPSounds;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.Nullable;

public class ShowtapePlayerBlockEntity
extends BaseEntityBlock
implements MenuProvider {
    public List<UUID> linkedEntities = new ArrayList<UUID>();
    public final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            ShowtapePlayerBlockEntity.this.setChanged();
            if (!ShowtapePlayerBlockEntity.this.level.isClientSide()) {
                ShowtapePlayerBlockEntity.this.level.sendBlockUpdated(ShowtapePlayerBlockEntity.this.getBlockPos(), ShowtapePlayerBlockEntity.this.getBlockState(), ShowtapePlayerBlockEntity.this.getBlockState(), 6);
            }
        }
    };
    protected final ContainerData data = new ContainerData(this){

        public int get(int i) {
            return 6;
        }

        public void set(int i, int value) {
        }

        public int getCount() {
            return 6;
        }
    };
    public int currentShowtapeSlot = 0;

    public ShowtapePlayerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.SHOWTAPE_PLAYER.get(), pPos, pBlockState);
    }

    public void tick() {
    }

    public Component getDisplayName() {
        return Component.translatableWithFallback((String)"menu.ffpackage.showtape_player", (String)"Showtape Player");
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1 && type == 0) {
            this.playSong((SoundEvent)FFPSounds.DAISY_BELL.get());
        }
        return super.triggerEvent(id, type);
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public void playSong(SoundEvent soundEvent) {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)FFPSounds.DAISY_BELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ShowtapePlayerMenu(i, inventory, (BlockEntity)this, this.data);
    }
}

