/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.PointLight;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.block.StainedRedstoneLampBlock;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class StainedLampBlockEntity
extends BaseEntityBlock {
    public PointLight pointLight;
    public final int colorId;

    public StainedLampBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.STAINED_REDSTONE_LAMP.get(), pPos, pBlockState);
        this.colorId = ((StainedRedstoneLampBlock)pBlockState.getBlock()).dyeColor.getTextureDiffuseColor();
    }

    public void setRemoved() {
        if (this.pointLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.pointLight);
            this.pointLight = null;
        }
        super.setRemoved();
    }

    public void tick() {
        if (this.level != null && !this.level.isClientSide) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)RedstoneLampBlock.LIT)).booleanValue()) {
            if (this.pointLight == null) {
                this.pointLight = new PointLight();
                BlockPos pos = this.getBlockPos();
                Vec3 position = pos.getCenter();
                VeilRenderSystem.renderer().getLightRenderer().addLight(((PointLight)this.pointLight.setBrightness(1.12f).setPosition((Vector3dc)new Vector3d(position.x, position.y, position.z))).setRadius(25.0f).setColor(this.colorId));
            } else {
                this.pointLight.setColor(this.colorId);
            }
        } else if (this.pointLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.pointLight);
            this.pointLight = null;
        }
    }
}

