/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.AreaLight;
import foundry.veil.api.client.render.light.Light;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.block.VintageSpotlightBlock;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VintageSpotlightBlockEntity
extends BaseEntityBlock {
    public AreaLight areaLight;
    public int colorId = DyeColor.WHITE.getTextureDiffuseColor();

    public VintageSpotlightBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.VINTAGE_SPOTLIGHT.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("colorId", this.colorId);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.colorId = tag.getInt("colorId");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
    }

    public void changeColor(int colorId) {
        this.colorId = colorId;
        this.setChanged();
    }

    public void setRemoved() {
        if (this.areaLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.areaLight);
            this.areaLight = null;
        }
        super.setRemoved();
    }

    public void tick() {
        if (this.level != null && !this.level.isClientSide) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.LIT)).booleanValue()) {
            if (this.areaLight == null) {
                this.areaLight = new AreaLight();
                BlockPos pos = this.getBlockPos();
                Direction direction = (Direction)this.getBlockState().getValue((Property)VintageSpotlightBlock.FACING);
                Vector2f size = new Vector2f(0.13f, 0.13f);
                Vec3 position = pos.getCenter().add(0.0, (double)0.28f, 0.0);
                switch ((Direction)this.getBlockState().getValue((Property)VintageSpotlightBlock.FACING)) {
                    case NORTH: {
                        position = position.add(0.0, (Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.HANGING) != false ? (double)-0.29f : (double)-0.27f, -0.25);
                        break;
                    }
                    case EAST: {
                        position = position.add(0.25, (Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.HANGING) != false ? (double)-0.29f : (double)-0.27f, 0.0);
                        break;
                    }
                    case SOUTH: {
                        position = position.add(0.0, (Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.HANGING) != false ? (double)-0.29f : (double)-0.27f, 0.25);
                        break;
                    }
                    case WEST: {
                        position = position.add(-0.25, (Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.HANGING) != false ? (double)-0.29f : (double)-0.27f, 0.0);
                    }
                }
                VeilRenderSystem.renderer().getLightRenderer().addLight(((AreaLight)this.areaLight.setBrightness(4.12f).setSize((double)size.x, (double)size.y).setAngle((float)Math.toRadians(26.9f)).setOrientation((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians((Boolean)this.getBlockState().getValue((Property)VintageSpotlightBlock.HANGING) != false ? 202.5 : 157.5), (float)Math.toRadians(180.0 + (double)direction.toYRot()), 0.0f)).setPosition((Vector3dc)new Vector3d(position.x, position.y, position.z))).setDistance(25.0f).setColor(this.colorId));
            } else {
                this.areaLight.setColor(this.colorId);
            }
        } else if (this.areaLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.areaLight);
            this.areaLight = null;
        }
    }
}

