/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.entity.goals.EndoAttackGoal;
import net.mudhut.ffpackage.level.entity.goals.EndoStrollGoal;
import net.mudhut.ffpackage.level.item.components.EndoSpawnerComponents;
import net.mudhut.ffpackage.level.item.components.FazWrenchComponent;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPSounds;
import net.neoforged.neoforge.fluids.FluidType;
import net.refractionapi.refraction.helper.entity.FrozenManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Endo01
extends PathfinderMob
implements NeutralMob {
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"chasing");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final Map<DyeColor, Integer> COLOR_BY_DYE = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_29868_ -> p_29868_, Endo01::createPupilColor)));
    private static final EntityDataAccessor<Byte> DATA_COLOR_ID = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> CURRENT_POSE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_POSSESSED = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockPos> SPAWN_POSITION = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Direction> SPAWN_ROTATION = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<BlockPos> SHOWTAPE_PLAYER_POS = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public final AnimationState idleState = new AnimationState();
    public final AnimationState danceState = new AnimationState();
    public final AnimationState possessionState = new AnimationState();
    public final AnimationState crouchState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState jumpscareState = new AnimationState();
    public SimpleContainer inventory = new SimpleContainer(2);
    private boolean dancing;
    private boolean isCrouched = false;
    public int possessTick = 0;
    public boolean jumpscaring = false;
    public final AnimationState pose1 = new AnimationState();
    public final AnimationState pose2 = new AnimationState();
    public final AnimationState pose3 = new AnimationState();

    public Endo01(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.ATTACK_KNOCKBACK, 0.1).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new EndoStrollGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new EndoAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(1, (Goal)new EndoLookAroundGoal(this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 25.0f){

            public boolean canUse() {
                Endo01 endo01;
                Mob mob = this.mob;
                return mob instanceof Endo01 && (endo01 = (Endo01)mob).isPossessed() && endo01.level().isNight() && super.canUse();
            }

            public boolean canContinueToUse() {
                Endo01 endo01;
                Mob mob = this.mob;
                return mob instanceof Endo01 && (endo01 = (Endo01)mob).isPossessed() && endo01.level().isNight() && super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)FFPItemRegistry.ENDO_01_SPAWN_EGG.get());
    }

    private void setupAnimationStates() {
        this.idleState.animateWhen(!this.navigation.isInProgress() && this.getCurrentPose() <= 1 && !this.isCrouched && !this.dancing, this.tickCount);
        this.danceState.animateWhen(this.dancing && !this.level().isNight(), this.tickCount);
        this.crouchState.animateWhen(this.isCrouched && this.getCurrentPose() != 2, this.tickCount);
        this.possessionState.animateWhen(this.possessTick <= 20 && this.possessTick > 0, this.tickCount);
        this.attackState.animateWhen(this.swinging && this.level().isNight() && !this.jumpscaring, this.tickCount);
        this.jumpscareState.animateWhen(this.jumpscaring, this.tickCount);
        this.pose1.animateWhen(this.getCurrentPose() == 1 && !this.level().isNight() && !this.navigation.isInProgress(), this.tickCount);
        this.pose2.animateWhen(this.getCurrentPose() == 2 && !this.level().isNight() && !this.navigation.isInProgress(), this.tickCount);
        this.pose3.animateWhen(this.getCurrentPose() == 3 && !this.level().isNight() && !this.navigation.isInProgress(), this.tickCount);
    }

    public void tick() {
        super.tick();
        if (this.getTarget() == null) {
            this.jumpscaring = false;
            FrozenManager.unfreeze((LivingEntity)this);
        }
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!this.level().isClientSide && attributeinstance != null) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ID);
            if (this.isAggressive()) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER);
            } else {
                attributeinstance.removeModifier(SPEED_MODIFIER_ID);
            }
        }
        if (this.possessTick >= 20) {
            --this.possessTick;
        }
        this.isCrouched = Block.canSupportCenter((LevelReader)this.level(), (BlockPos)this.blockPosition().offset(0, 2, 0), (Direction)Direction.UP);
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        EquipmentSlot interactedSlot = this.getClickedSlot(vec);
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (!player.isCrouching()) {
            if (interactedSlot == EquipmentSlot.MAINHAND || interactedSlot == EquipmentSlot.OFFHAND) {
                InteractionHand setHand;
                InteractionHand interactionHand = setHand = interactedSlot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                if (this.getItemInHand(setHand).isEmpty()) {
                    this.setItemInHand(setHand, player.getMainHandItem());
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    FFPackage.LOGGER.info("Gave item to {}", (Object)setHand);
                    this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, this.getItemInHand(setHand));
                    this.setItemInHand(setHand, ItemStack.EMPTY);
                    FFPackage.LOGGER.info("Took item from {}", (Object)setHand);
                    this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                    return InteractionResult.SUCCESS;
                }
                player.getInventory().add(this.getItemInHand(setHand));
                this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (interactedSlot == EquipmentSlot.HEAD) {
                    if (armorItem.getEquipmentSlot() == EquipmentSlot.HEAD) {
                        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                            this.setItemSlot(EquipmentSlot.HEAD, player.getMainHandItem());
                            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        } else {
                            player.getInventory().add(this.getItemBySlot(EquipmentSlot.HEAD));
                            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.CHEST) {
                    if (armorItem.getEquipmentSlot() == EquipmentSlot.CHEST) {
                        if (this.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
                            this.setItemSlot(EquipmentSlot.CHEST, player.getMainHandItem());
                            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        } else {
                            player.getInventory().add(this.getItemBySlot(EquipmentSlot.CHEST));
                            this.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
                        }
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.LEGS) {
                    if (armorItem.getEquipmentSlot() == EquipmentSlot.LEGS) {
                        if (this.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                            this.setItemSlot(EquipmentSlot.LEGS, player.getMainHandItem());
                            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        } else {
                            player.getInventory().add(this.getItemBySlot(EquipmentSlot.LEGS));
                            this.setItemSlot(EquipmentSlot.LEGS, ItemStack.EMPTY);
                        }
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.FEET && armorItem.getEquipmentSlot() == EquipmentSlot.FEET) {
                    if (this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                        this.setItemSlot(EquipmentSlot.FEET, player.getMainHandItem());
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    } else {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.FEET));
                        this.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
                    }
                    this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                    return InteractionResult.SUCCESS;
                }
            } else if (itemStack.is(Items.SHEARS)) {
                if (interactedSlot == EquipmentSlot.HEAD) {
                    if (!this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.HEAD));
                        this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.CHEST) {
                    if (!this.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.CHEST));
                        this.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.LEGS) {
                    if (!this.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.LEGS));
                        this.setItemSlot(EquipmentSlot.LEGS, ItemStack.EMPTY);
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                        return InteractionResult.SUCCESS;
                    }
                } else if (interactedSlot == EquipmentSlot.FEET && !this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                    player.getInventory().add(this.getItemBySlot(EquipmentSlot.FEET));
                    this.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
                    this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.interactAt(player, vec, hand);
    }

    private EquipmentSlot getClickedSlot(Vec3 vector) {
        EquipmentSlot equipmentslot = null;
        double vecY = vector.y / (double)(this.getScale() * this.getAgeScale());
        double vecX = vector.x / (double)(this.getScale() * this.getAgeScale());
        double vecZ = vector.z / (double)(this.getScale() * this.getAgeScale());
        if (vecY >= 0.1 && vecY < 0.55) {
            equipmentslot = EquipmentSlot.FEET;
        }
        if (vecY >= 0.9 && vecY < 1.6) {
            equipmentslot = EquipmentSlot.CHEST;
        }
        if (vecY >= 0.4 && vecY < 1.2000000000000002) {
            equipmentslot = EquipmentSlot.LEGS;
        }
        if (vecY >= 1.6) {
            equipmentslot = EquipmentSlot.HEAD;
        }
        if (this.getDirection() == Direction.NORTH ? vecX <= -0.15 : (this.getDirection() == Direction.SOUTH ? vecX >= 0.15 : (this.getDirection() == Direction.WEST ? vecZ >= 0.15 : vecZ <= -0.15))) {
            equipmentslot = EquipmentSlot.OFFHAND;
        }
        if (this.getDirection() == Direction.NORTH ? vecX >= 0.15 : (this.getDirection() == Direction.SOUTH ? vecX <= -0.15 : (this.getDirection() == Direction.WEST ? vecZ <= -0.15 : vecZ >= 0.15))) {
            equipmentslot = EquipmentSlot.MAINHAND;
        }
        return equipmentslot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (player.isCrouching()) {
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                DyeColor dyecolor = dyeitem.getDyeColor();
                if (dyecolor == this.getColor()) return super.mobInteract(player, hand);
                this.setColor(dyecolor);
                this.level().playSound(player, this.blockPosition(), SoundEvents.DYE_USE, SoundSource.AMBIENT);
                if (player.getAbilities().instabuild) return InteractionResult.SUCCESS;
                itemStack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(FFPItemRegistry.FAZ_WRENCH)) {
                if (!player.isCreative() || this.isPossessed() || this.getColor() != DyeColor.WHITE) {
                    ItemStack endoSpawnEgg = FFPItemRegistry.ENDO_01_SPAWN_EGG.toStack();
                    endoSpawnEgg.set((DataComponentType)FFPDataComponents.ENDO_SPAWNER.value(), (Object)new EndoSpawnerComponents(this.isPossessed(), (Byte)this.entityData.get(DATA_COLOR_ID)));
                    player.getInventory().add(endoSpawnEgg);
                    if (!this.getMainHandItem().isEmpty()) {
                        player.getInventory().add(this.getMainHandItem());
                    }
                    if (!this.getOffhandItem().isEmpty()) {
                        player.getInventory().add(this.getOffhandItem());
                    }
                    if (!this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.HEAD));
                    }
                    if (!this.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.CHEST));
                    }
                    if (!this.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.LEGS));
                    }
                    if (!this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                        player.getInventory().add(this.getItemBySlot(EquipmentSlot.FEET));
                    }
                }
                this.discard();
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.isEmpty()) return InteractionResult.FAIL;
            this.setCurrentPose(this.getCurrentPose() + 1);
            if (this.getCurrentPose() <= 3) return InteractionResult.SUCCESS;
            this.setCurrentPose(0);
            return InteractionResult.SUCCESS;
        }
        if (!itemStack.is(FFPItemRegistry.FAZ_WRENCH)) return super.mobInteract(player, hand);
        FazWrenchComponent fazWrenchComponent = (FazWrenchComponent)player.getMainHandItem().get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value());
        if (fazWrenchComponent == null || fazWrenchComponent.blockPos().equals((Object)Vec3.ZERO.toVector3f())) return InteractionResult.SUCCESS;
        this.level().playSound(player, this.blockPosition(), (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.NEUTRAL);
        this.setShowtapePlayerPos(new BlockPos(new Vec3i((int)fazWrenchComponent.blockPos().x, (int)fazWrenchComponent.blockPos().y, (int)fazWrenchComponent.blockPos().z)));
        player.getMainHandItem().set((DataComponentType)FFPDataComponents.FAZ_WRENCH.value(), (Object)new FazWrenchComponent(Vec3.ZERO.toVector3f()));
        return InteractionResult.SUCCESS;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        boolean flag = this.getItemBySlot(EquipmentSlot.FEET).isEmpty();
        this.playSound(flag ? SoundEvents.COPPER_STEP : (SoundEvent)FFPSounds.ENDO_WALK.get(), 1.0f, 1.0f);
    }

    public static int getColor(DyeColor dyeColor) {
        return COLOR_BY_DYE.get(dyeColor);
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_COLOR_ID) & 0xF));
    }

    private static int createPupilColor(DyeColor dyeColor) {
        if (dyeColor == DyeColor.WHITE) {
            return -1644826;
        }
        int i = dyeColor.getTextureDiffuseColor();
        return FastColor.ARGB32.color((int)255, (int)Mth.floor((float)((float)FastColor.ARGB32.red((int)i) * 0.75f)), (int)Mth.floor((float)((float)FastColor.ARGB32.green((int)i) * 0.75f)), (int)Mth.floor((float)((float)FastColor.ARGB32.blue((int)i) * 0.75f)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPAWN_POSITION, (Object)new BlockPos(0, 0, 0));
        builder.define(SPAWN_ROTATION, (Object)Direction.NORTH);
        builder.define(DATA_COLOR_ID, (Object)0);
        builder.define(CURRENT_POSE, (Object)0);
        builder.define(IS_POSSESSED, (Object)false);
        builder.define(SHOWTAPE_PLAYER_POS, (Object)new BlockPos(0, 0, 0));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("Color", (byte)this.getColor().getId());
        compound.putInt("CurrentPose", this.getCurrentPose());
        compound.putBoolean("IsPossessed", this.isPossessed());
        compound.putByte("SpawnRotation", (byte)this.getSpawnRotation().get3DDataValue());
        compound.putInt("SpawnX", this.getSpawnPosition().getX());
        compound.putInt("SpawnY", this.getSpawnPosition().getY());
        compound.putInt("SpawnZ", this.getSpawnPosition().getZ());
        compound.putInt("ShowPlayerX", this.getShowtapePlayerPos().getX());
        compound.putInt("ShowPlayerY", this.getShowtapePlayerPos().getY());
        compound.putInt("ShowPlayerZ", this.getShowtapePlayerPos().getZ());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setColor(DyeColor.byId((int)compound.getByte("Color")));
        this.setCurrentPose(compound.getInt("CurrentPose"));
        this.setPossessed(compound.getBoolean("IsPossessed"));
        int spawnX = compound.getInt("SpawnX");
        int spawnY = compound.getInt("SpawnY");
        int spawnZ = compound.getInt("SpawnZ");
        this.setSpawnPosition(new BlockPos(spawnX, spawnY, spawnZ));
        this.setSpawnRotation(Direction.from3DDataValue((int)compound.getByte("SpawnRotation")));
        int playerX = compound.getInt("ShowPlayerX");
        int playerY = compound.getInt("ShowPlayerXY");
        int playerZ = compound.getInt("ShowPlayerZ");
        this.setShowtapePlayerPos(new BlockPos(playerX, playerY, playerZ));
    }

    public void setSpawnPosition(BlockPos blockPos) {
        this.entityData.set(SPAWN_POSITION, (Object)blockPos);
    }

    public BlockPos getSpawnPosition() {
        return (BlockPos)this.entityData.get(SPAWN_POSITION);
    }

    public void setSpawnRotation(Direction direction) {
        this.entityData.set(SPAWN_ROTATION, (Object)direction);
    }

    public Direction getSpawnRotation() {
        return (Direction)this.entityData.get(SPAWN_ROTATION);
    }

    public void setShowtapePlayerPos(BlockPos blockPos) {
        this.entityData.set(SHOWTAPE_PLAYER_POS, (Object)blockPos);
    }

    public BlockPos getShowtapePlayerPos() {
        return (BlockPos)this.entityData.get(SHOWTAPE_PLAYER_POS);
    }

    public void setColor(DyeColor dyeColor) {
        byte colorId = (Byte)this.entityData.get(DATA_COLOR_ID);
        this.entityData.set(DATA_COLOR_ID, (Object)((byte)(colorId & 0xF0 | dyeColor.getId() & 0xF)));
    }

    public void setCurrentPose(int pose) {
        this.entityData.set(CURRENT_POSE, (Object)pose);
    }

    public int getCurrentPose() {
        return (Integer)this.entityData.get(CURRENT_POSE);
    }

    public void setPossessed(boolean value) {
        this.entityData.set(IS_POSSESSED, (Object)value);
    }

    public boolean isPossessed() {
        return (Boolean)this.entityData.get(IS_POSSESSED);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected void onEffectAdded(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        this.removeAllEffects();
        super.onEffectAdded(pEffectInstance, pEntity);
    }

    public void aiStep() {
        super.aiStep();
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int i) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
    }

    public void startPersistentAngerTimer() {
    }

    public static class EndoLookAroundGoal
    extends RandomLookAroundGoal {
        public final Endo01 endo01;

        public EndoLookAroundGoal(Endo01 endo01) {
            super((Mob)endo01);
            this.endo01 = endo01;
        }

        public boolean canUse() {
            return this.endo01.isPossessed() && this.endo01.level().isNight() && super.canUse();
        }

        public boolean canContinueToUse() {
            return this.endo01.isPossessed() && this.endo01.level().isNight() && super.canContinueToUse();
        }
    }
}

