/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity.goals;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.refractionapi.refraction.helper.entity.FrozenManager;

public class EndoAttackGoal
extends MeleeAttackGoal {
    private static final ResourceLocation DAMAGE_MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"stuffing");
    private static final AttributeModifier DAMAGE_MODIFIER = new AttributeModifier(DAMAGE_MODIFIER_ID, -100.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public int currentSlot = 0;

    public EndoAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.mob.getTarget();
        AttributeInstance attributeinstance = this.mob.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attributeinstance == null) {
            return;
        }
        if (target != null && !this.mob.level().isClientSide) {
            if (target.getHealth() <= 13.0f) {
                attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
                attributeinstance.addTransientModifier(DAMAGE_MODIFIER);
                EquipmentSlot playerSlot = EquipmentSlot.FEET;
                Item suitItem = (Item)FFPItemRegistry.FREDDY_SUIT_FEET.get();
                if (this.mob.distanceTo((Entity)target) <= 1.3f) {
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)target;
                        FrozenManager.setFrozenTicks((LivingEntity)target, (int)20);
                        FrozenManager.setFrozen((LivingEntity)this.mob, (Vec3)this.mob.position());
                        serverPlayer.lookAt(EntityAnchorArgument.Anchor.EYES, this.mob.getEyePosition().add(0.0, (double)0.8f, 0.0));
                        this.mob.lookAt(EntityAnchorArgument.Anchor.EYES, serverPlayer.getEyePosition());
                        ((Endo01)this.mob).jumpscaring = true;
                        if (this.mob.tickCount % 50 == 0) {
                            int n = this.currentSlot = this.currentSlot >= 4 ? 0 : this.currentSlot + 1;
                            if (this.currentSlot != 0) {
                                EquipmentSlot equipmentSlot = this.currentSlot == 1 ? EquipmentSlot.FEET : (this.currentSlot == 2 ? EquipmentSlot.LEGS : (playerSlot = this.currentSlot == 3 ? EquipmentSlot.CHEST : EquipmentSlot.HEAD));
                                suitItem = this.currentSlot == 1 ? (Item)FFPItemRegistry.FREDDY_SUIT_FEET.get() : (this.currentSlot == 2 ? (Item)FFPItemRegistry.FREDDY_SUIT_LEGS.get() : (this.currentSlot == 3 ? (Item)FFPItemRegistry.FREDDY_SUIT_TORSO.get() : (Item)FFPItemRegistry.FREDDY_SUIT_HEAD.get()));
                            }
                            serverPlayer.setItemSlot(playerSlot, suitItem.getDefaultInstance());
                        }
                    }
                } else {
                    this.currentSlot = 0;
                    ((Endo01)this.mob).jumpscaring = false;
                    FrozenManager.unfreeze((LivingEntity)this.mob);
                    attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
                }
            } else {
                this.currentSlot = 0;
                ((Endo01)this.mob).jumpscaring = false;
                FrozenManager.unfreeze((LivingEntity)this.mob);
                attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
            }
        }
    }

    public boolean canUse() {
        Endo01 endo01;
        PathfinderMob pathfinderMob = this.mob;
        return pathfinderMob instanceof Endo01 && (endo01 = (Endo01)pathfinderMob).isPossessed() && this.mob.level().isNight() && super.canUse();
    }

    public boolean canContinueToUse() {
        Endo01 endo01;
        PathfinderMob pathfinderMob = this.mob;
        return pathfinderMob instanceof Endo01 && (endo01 = (Endo01)pathfinderMob).isPossessed() && this.mob.level().isNight() && super.canContinueToUse();
    }
}

