/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.refractionapi.refraction.helper.runnable.Runnabler;

public class EndoStrollGoal
extends RandomStrollGoal {
    protected final Endo01 endo;

    public EndoStrollGoal(Endo01 endo, double speedModifier) {
        super((PathfinderMob)endo, speedModifier);
        this.endo = endo;
    }

    public void tick() {
        if (!this.endo.level().isNight()) {
            this.forceTrigger = true;
            Vec3 position = this.endo.getSpawnPosition().getCenter();
            this.endo.getNavigation().moveTo(position.x, position.y, position.z, -100, (double)1.2f);
            this.endo.setYHeadRot(this.endo.getSpawnRotation().toYRot());
            this.endo.setYBodyRot(this.endo.getSpawnRotation().toYRot());
            if (this.endo.getNavigation().isStuck()) {
                this.endo.getNavigation().shouldRecomputePath(new BlockPos((int)position.x, (int)position.y, (int)position.z));
            }
            if (this.endo.getNavigation().isDone()) {
                Runnabler.create().delayRun(20, runnabler -> {
                    this.endo.moveTo(new BlockPos((int)position.x, this.endo.getSpawnPosition().getY(), (int)position.z), this.endo.getSpawnRotation().toYRot(), 0.0f);
                    this.endo.getNavigation().stop();
                });
            }
        } else {
            this.forceTrigger = false;
        }
        super.tick();
    }

    public boolean canUse() {
        return this.endo.isPossessed() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.endo.isPossessed() && super.canContinueToUse();
    }
}

