/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.inventory.EndoContainer;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.mudhut.ffpackage.registries.FFPTagsRegistry;
import org.jetbrains.annotations.NotNull;

public class EndoConfigMenu
extends AbstractContainerMenu {
    public int containerId;
    public Container endoContainer;
    public static Endo01 endoSkeleton;

    public EndoConfigMenu(int containerId, Inventory inventory, final Endo01 endoSkeleton) {
        super(FFPMenuTypes.ENDO_CONFIG.get(), containerId);
        int i;
        this.endoContainer = new EndoContainer(endoSkeleton);
        EndoConfigMenu.endoSkeleton = endoSkeleton;
        this.containerId = containerId;
        this.endoContainer.startOpen(inventory.player);
        this.addSlot(new Slot(this, this.endoContainer, 0, 82, -1){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return endoSkeleton != null && itemStack.is(FFPTagsRegistry.CPUS) && !this.hasItem();
            }

            public boolean isActive() {
                return endoSkeleton != null && !this.hasItem();
            }
        });
        this.addSlot(new Slot(this, this.endoContainer, 1, 82, 17){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem();
            }

            public boolean isActive() {
                return !this.hasItem();
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (index < 36) {
            if (!this.moveItemStackTo(slot.getItem(), 0, 36, false)) {
                return itemstack;
            }
        } else if (index < 38) {
            if (!this.moveItemStackTo(slot.getItem(), 0, 36, false)) {
                return itemstack;
            }
        } else {
            return itemstack;
        }
        if (slot.getItem().getCount() == 0) {
            slot.set(itemstack);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, itemstack);
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return endoSkeleton != null && (endoSkeleton.isAlive() || player.canInteractWithEntity((Entity)endoSkeleton, 4.0));
    }

    public void removed(Player player) {
        this.endoContainer.stopOpen(player);
        super.removed(player);
    }
}

