/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.level.entity.Endo01;
import org.jetbrains.annotations.NotNull;

public class EndoContainer
implements Container {
    public final Endo01 endoSkeleton;
    private final NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);

    public EndoContainer(Endo01 endoSkeleton) {
        this.endoSkeleton = endoSkeleton;
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator var1 = this.itemStacks.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)var1.next()).isEmpty());
        return false;
    }

    public ItemStack getItem(int i) {
        return i > this.itemStacks.size() - 1 ? ItemStack.EMPTY : (ItemStack)this.itemStacks.get(i);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = (ItemStack)this.itemStacks.get(index);
        if (index == 2 && !itemstack.isEmpty()) {
            return ContainerHelper.removeItem(this.itemStacks, (int)index, (int)itemstack.getCount());
        }
        return ContainerHelper.removeItem(this.itemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.itemStacks, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return this.endoSkeleton != null && (this.endoSkeleton.isAlive() || player.canInteractWithEntity((Entity)this.endoSkeleton, 4.0));
    }

    public void clearContent() {
        this.itemStacks.clear();
    }
}

