/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mudhut.ffpackage.level.block.entity.MidnightMotorMachineBlockEntity;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MidnightMotoristMachineMenu
extends AbstractContainerMenu {
    private Slot tokenSlot;
    private Slot ticketSlot;
    public final MidnightMotorMachineBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public MidnightMotoristMachineMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public MidnightMotoristMachineMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData containerData) {
        super(FFPMenuTypes.MIDNIGHT_MOTOR.get(), containerId);
        int i;
        this.blockEntity = (MidnightMotorMachineBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = containerData;
        this.tokenSlot = new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 47, 59){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && !MidnightMotoristMachineMenu.this.blockEntity.isGameActive && itemStack.is(FFPItemRegistry.FAZ_TOKEN) && itemStack.getCount() == 1;
            }
        };
        this.ticketSlot = new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 1, 103, 59){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return false;
            }
        };
        this.addSlot(this.tokenSlot);
        this.addSlot(this.ticketSlot);
        this.addDataSlots(this.data);
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 100 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 158));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemstack = slotItem.copy();
            if (index != 0 && index != 1 && index != 2) {
                if (index >= 3 && index < 30) {
                    if (!this.moveItemStackTo(slotItem, 30, 39, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    if (index >= 30 && index < 39 && !this.moveItemStackTo(slotItem, 0, 30, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (!this.moveItemStackTo(slotItem, 0, 39, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return MidnightMotoristMachineMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)FFPDecorBlockRegistry.MM_MACHINE.get()));
    }
}

