/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.item.components.EndoSpawnerComponents;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPEntitiesRegistry;
import org.apache.commons.lang3.text.WordUtils;

public class EndoSpawnerItem
extends Item {
    public EndoSpawnerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext blockplacecontext = new BlockPlaceContext(context);
        BlockPos blockpos = blockplacecontext.getClickedPos();
        ItemStack itemstack = context.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos);
        AABB aabb = ((EntityType)FFPEntitiesRegistry.ENDO_01.get()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aabb) && level.getEntities(null, aabb).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverlevel, (ItemStack)itemstack, (Player)context.getPlayer());
                Endo01 endo01 = (Endo01)((EntityType)FFPEntitiesRegistry.ENDO_01.get()).create(serverlevel, consumer, blockpos, MobSpawnType.SPAWN_EGG, true, true);
                if (endo01 == null) {
                    return InteractionResult.FAIL;
                }
                boolean possessed = ((EndoSpawnerComponents)itemstack.get((DataComponentType)FFPDataComponents.ENDO_SPAWNER.value())).isPossessed();
                byte eyeColor = ((EndoSpawnerComponents)itemstack.get((DataComponentType)FFPDataComponents.ENDO_SPAWNER.value())).eyeColor();
                endo01.setPossessed(possessed);
                endo01.setColor(DyeColor.byId((int)(eyeColor & 0xF)));
                float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                endo01.moveTo(endo01.getX(), endo01.getY(), endo01.getZ(), f, 0.0f);
                endo01.setYBodyRot(f);
                serverlevel.addFreshEntityWithPassengers((Entity)endo01);
                endo01.setSpawnRotation(Direction.fromYRot((double)f));
                endo01.setSpawnPosition(new BlockPos((int)endo01.getX(), (int)endo01.getY(), (int)endo01.getZ()));
                level.playSound(null, endo01.getX(), endo01.getY(), endo01.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                endo01.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        EndoSpawnerComponents spawnerComponents = (EndoSpawnerComponents)stack.get(FFPDataComponents.ENDO_SPAWNER);
        if (spawnerComponents != null) {
            Objects.requireNonNull(tooltipComponents);
            tooltipComponents.add((Component)Component.literal((String)WordUtils.capitalize((String)DyeColor.byId((int)(spawnerComponents.eyeColor() & 0xF)).toString()).replace("_", " ")).withColor(DyeColor.byId((int)(spawnerComponents.eyeColor() & 0xF)).getTextureDiffuseColor()));
            if (tooltipFlag.isAdvanced()) {
                tooltipComponents.add((Component)Component.literal((String)("Possessed: " + spawnerComponents.isPossessed())).withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

