/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.item.components.FazWrenchComponent;
import net.mudhut.ffpackage.registries.FFPDataComponents;

public class FazWrenchItem
extends Item {
    public FazWrenchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (interactionTarget instanceof Endo01 && !usedHand.equals((Object)InteractionHand.OFF_HAND) && !player.isCrouching()) {
            player.openItemGui(itemStack, InteractionHand.MAIN_HAND);
            player.swing(usedHand);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public BlockPos getSelectedPlayer() {
        FazWrenchComponent selectedPlayer = (FazWrenchComponent)this.components().get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value());
        if (selectedPlayer == null) {
            return BlockPos.ZERO;
        }
        return new BlockPos((int)selectedPlayer.blockPos().x, (int)selectedPlayer.blockPos().y, (int)selectedPlayer.blockPos().z);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FazWrenchComponent selectedPlayer = (FazWrenchComponent)stack.get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value());
        if (selectedPlayer != null) {
            boolean flag = !selectedPlayer.blockPos().equals((Object)Vec3.ZERO.toVector3f());
            Objects.requireNonNull(tooltipComponents);
            BlockPos blockPos = new BlockPos((int)selectedPlayer.blockPos().x, (int)selectedPlayer.blockPos().y, (int)selectedPlayer.blockPos().z);
            tooltipComponents.add((Component)Component.literal((String)("Showtape Player Selected: " + String.valueOf(blockPos))).withStyle(ChatFormatting.BLUE));
        }
    }
}

