/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.mudhut.ffpackage.registries.FFPDamageTypes;
import net.refractionapi.refraction.helper.misc.RefractionMisc;
import org.jetbrains.annotations.Nullable;

public class PlushSuitItem
extends ArmorItem {
    public ResourceLocation resourceLocation;

    public PlushSuitItem(ResourceLocation resourceLocation, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        this.resourceLocation = resourceLocation;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ServerPlayer serverPlayer;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof ServerPlayer && this.checkSlots((Player)(serverPlayer = (ServerPlayer)entity))) {
            serverPlayer.hurt(RefractionMisc.damageSource(FFPDamageTypes.STUFFED_IN_SUIT, (Level)serverPlayer.level()), 0.4f);
        }
    }

    public boolean checkSlots(Player player) {
        return player.getItemBySlot(EquipmentSlot.FEET).is((Item)this) || player.getItemBySlot(EquipmentSlot.LEGS).is((Item)this) || player.getItemBySlot(EquipmentSlot.CHEST).is((Item)this) || player.getItemBySlot(EquipmentSlot.HEAD).is((Item)this);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return this.resourceLocation;
    }
}

