/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.registries;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.mudhut.ffpackage.level.block.BlackOlivePizzaBlock;
import net.mudhut.ffpackage.level.block.CheesePizzaBlock;
import net.mudhut.ffpackage.level.block.CrateBlock;
import net.mudhut.ffpackage.level.block.PepperoniPizzaBlock;
import net.mudhut.ffpackage.level.block.ShowtapePlayerBlock;
import net.mudhut.ffpackage.level.block.TomatoBushBlock;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FFPBlockRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ffpackage");
    public static final DeferredBlock<Block> CRATE = FFPBlockRegistry.registerBlock("crate", () -> new CrateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)));
    public static final DeferredBlock<Block> TOMATO_BUSH = FFPBlockRegistry.registerBlock("tomato_bush", () -> new TomatoBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final DeferredBlock<Block> SHOWTAPE_PLAYER = FFPBlockRegistry.registerBlock("showtape_player", () -> new ShowtapePlayerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> COOKED_PEPPERONI_PIZZA = FFPBlockRegistry.registerBlock("cooked_pepperoni_pizza", () -> new PepperoniPizzaBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> COOKED_CHEESE_PIZZA = FFPBlockRegistry.registerBlock("cooked_cheese_pizza", () -> new CheesePizzaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COOKED_PEPPERONI_PIZZA.get()))));
    public static final DeferredBlock<Block> COOKED_BLACK_OLIVE_PIZZA = FFPBlockRegistry.registerBlock("cooked_black_olive_pizza", () -> new BlackOlivePizzaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COOKED_PEPPERONI_PIZZA.get()))));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        FFPBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        FFPItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

