/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.registries;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.mudhut.ffpackage.level.block.BlackSconceBlock;
import net.mudhut.ffpackage.level.block.ConfettiTableBlock;
import net.mudhut.ffpackage.level.block.DirectionalBlock;
import net.mudhut.ffpackage.level.block.HangingCloudBlock;
import net.mudhut.ffpackage.level.block.HangingCloudChainBlock;
import net.mudhut.ffpackage.level.block.HangingStarsBlock;
import net.mudhut.ffpackage.level.block.HangingStarsChainBlock;
import net.mudhut.ffpackage.level.block.MidnightMotorMachineBlock;
import net.mudhut.ffpackage.level.block.PartyHatBlock;
import net.mudhut.ffpackage.level.block.PosterBlock;
import net.mudhut.ffpackage.level.block.SittableBlock;
import net.mudhut.ffpackage.level.block.SodaMachineBlock;
import net.mudhut.ffpackage.level.block.TrashPileBlock;
import net.mudhut.ffpackage.level.block.VintageSpotlightBlock;
import net.mudhut.ffpackage.level.block.WallHangingDecorBlock;
import net.mudhut.ffpackage.level.block.WallPapersBlock;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FFPDecorBlockRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ffpackage");
    public static final DeferredBlock<Block> SODA_MACHINE = FFPDecorBlockRegistry.registerBlock("soda_machine", () -> new SodaMachineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion()));
    public static final DeferredBlock<Block> MM_MACHINE = FFPDecorBlockRegistry.registerBlock("midnight_motorist_machine", () -> new MidnightMotorMachineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion()));
    public static final DeferredBlock<Block> WOOD_CLOUD = FFPDecorBlockRegistry.registerBlock("wooden_cloud", () -> new HangingCloudBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(DyeColor.WHITE).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> WOOD_CLOUD_CHAIN = FFPDecorBlockRegistry.registerBlock("wooden_cloud_chain", () -> new HangingCloudChainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHAIN).mapColor(DyeColor.BLACK).pushReaction(PushReaction.DESTROY).noCollission()));
    public static final DeferredBlock<Block> HANGING_STARS = FFPDecorBlockRegistry.registerBlock("hanging_stars", () -> new HangingStarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(DyeColor.WHITE).pushReaction(PushReaction.DESTROY).noCollission()));
    public static final DeferredBlock<Block> STARS_CHAIN = FFPDecorBlockRegistry.registerBlock("hanging_stars_chain", () -> new HangingStarsChainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(DyeColor.BLACK).pushReaction(PushReaction.DESTROY).noCollission()));
    public static final DeferredBlock<Block> WOOD_SUN = FFPDecorBlockRegistry.registerBlock("wooden_sun", () -> new WallHangingDecorBlock(FFPVoxelShapes.WOOD_SUN, true, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(DyeColor.YELLOW).pushReaction(PushReaction.DESTROY).noOcclusion()));
    public static final DeferredBlock<Block> STAGE_SPEAKER = FFPDecorBlockRegistry.registerBlock("stage_speaker", () -> new DirectionalBlock(FFPVoxelShapes.STAGE_SPEAKER, BlockBehaviour.Properties.of().noOcclusion().mapColor(DyeColor.BLACK).sound(SoundType.COPPER).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> VINTAGE_SPOTLIGHT = FFPDecorBlockRegistry.registerBlock("vintage_spotlight", () -> new VintageSpotlightBlock(BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.COPPER)));
    public static final DeferredBlock<Block> STARRED_BLACK_CHAIR = FFPDecorBlockRegistry.registerBlock("starred_black_chair", () -> new SittableBlock(BlockBehaviour.Properties.of().sound(SoundType.COPPER).noCollission()));
    public static final DeferredBlock<Block> BLACK_SCONCE = FFPDecorBlockRegistry.registerBlock("black_sconce", () -> new BlackSconceBlock(BlockBehaviour.Properties.of().sound(SoundType.COPPER).lightLevel(FFPDecorBlockRegistry.litBlockEmission(7))));
    public static final DeferredBlock<Block> CONFETTI_TABLE = FFPDecorBlockRegistry.registerBlock("confetti_table", () -> new ConfettiTableBlock(BlockBehaviour.Properties.of().sound(SoundType.SCAFFOLDING).noOcclusion()));
    public static final DeferredBlock<Block> FREDDY_POSTER = FFPDecorBlockRegistry.registerBlock("freddy_poster", () -> new PosterBlock(FFPVoxelShapes.UPPER_POSTER, "Fun Time!", "freddy", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> BONNIE_POSTER = FFPDecorBlockRegistry.registerBlock("bonnie_poster", () -> new PosterBlock(FFPVoxelShapes.LOWER_POSTER, "Party Time!", "bonnie", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> CHICA_POSTER = FFPDecorBlockRegistry.registerBlock("chica_poster", () -> new PosterBlock(FFPVoxelShapes.LOWER_POSTER, "Eating Time!", "chica", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> FOXY_POSTER = FFPDecorBlockRegistry.registerBlock("foxy_poster", () -> new PosterBlock(FFPVoxelShapes.LOWER_POSTER, "Play Time!", "foxy", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> PARTY_POSTER = FFPDecorBlockRegistry.registerBlock("party_poster", () -> new PosterBlock(FFPVoxelShapes.LOWER_POSTER, "Let's Party!", "party", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> CELEBRATE_POSTER = FFPDecorBlockRegistry.registerBlock("celebrate_poster", () -> new PosterBlock(FFPVoxelShapes.GENERIC_CHAIN, "Celebrate", "celebrate", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> RULES_POSTER = FFPDecorBlockRegistry.registerBlock("rules_poster", () -> new PosterBlock(FFPVoxelShapes.UPPER_POSTER, "Rules", "rules", BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> WHITE_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("white_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> LIGHT_GRAY_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("light_gray_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> GRAY_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("gray_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> BLACK_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("black_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> BROWN_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("brown_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> RED_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("red_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> ORANGE_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("orange_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> YELLOW_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("yellow_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> LIME_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("lime_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> GREEN_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("green_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> CYAN_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("cyan_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> LIGHT_BLUE_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("light_blue_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> BLUE_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("blue_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> PURPLE_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("purple_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> MAGENTA_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("magenta_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> PINK_PARTY_HAT = FFPDecorBlockRegistry.registerBlock("pink_party_hat", () -> new PartyHatBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> TRASH_PILE = FFPDecorBlockRegistry.registerBlock("trash_pile", () -> new TrashPileBlock(BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.GRAVEL).noCollission()));
    public static final DeferredBlock<Block> WALL_PAPERS = FFPDecorBlockRegistry.registerBlock("paper_cluster", () -> new WallPapersBlock(BlockBehaviour.Properties.of().noOcclusion().noCollission().sound(SoundType.WOOL)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        FFPDecorBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        FFPItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return isLit -> (Boolean)isLit.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }
}

