/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.server.purchase;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.mudhut.ffpackage.registries.FFPEvents;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import net.refractionapi.refraction.feature.scheme.ServerScheme;
import net.refractionapi.refraction.util.Pair;

public class PurchaseSys
extends ServerScheme {
    private final BlockPos pos;
    private final Item currencyItem;
    private static final Int2ObjectArrayMap<PurchasableItem> ITEMS = new Int2ObjectArrayMap();

    public PurchaseSys(ServerPlayer player) {
        super(FFPMenuTypes.PURCHASE, player);
        this.pos = player.blockPosition();
        this.currencyItem = Items.EMERALD.asItem();
    }

    public boolean stillValid() {
        return this.pos.distToCenterSqr((Position)this.player.position()) < 4.0 && super.stillValid();
    }

    public int buyingPower() {
        return this.player.inventoryMenu.getItems().stream().filter(is -> is.is(this.currencyItem)).mapToInt(ItemStack::getCount).sum();
    }

    public Component handlePurchase(List<Pair<PurchasableItem, Integer>> items) {
        int buyingPower;
        if (items.isEmpty()) {
            return Component.literal((String)"No Items!").withStyle(ChatFormatting.DARK_RED);
        }
        int totalPrice = items.stream().map(pair -> ((PurchasableItem)pair.first).price * (Integer)pair.second).reduce(0, Integer::sum);
        if (totalPrice > (buyingPower = this.buyingPower())) {
            return Component.literal((String)"Not Enough Funds!").withStyle(ChatFormatting.DARK_RED);
        }
        items.forEach(pair -> {
            for (int i = 0; i < (Integer)pair.second; ++i) {
                this.purchase((PurchasableItem)pair.first);
            }
        });
        return Component.literal((String)"Success!").withStyle(ChatFormatting.GREEN);
    }

    public boolean purchase(PurchasableItem item) {
        if (!this.takeFunds(item.price)) {
            return false;
        }
        this.player.addItem(item.item().getDefaultInstance());
        return true;
    }

    public boolean takeFunds(int funds) {
        if (this.buyingPower() < funds) {
            return false;
        }
        Inventory inventory = this.player.getInventory();
        int remaining = funds;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).is(this.currencyItem)) continue;
            int count = inventory.getItem(i).getCount();
            if (count > remaining) {
                inventory.getItem(i).shrink(remaining);
                return true;
            }
            remaining -= count;
            inventory.removeItem(i, count);
        }
        return true;
    }

    public static void init() {
        PurchaseSys.addItem(FFPItemRegistry.CATALOG, 4);
        PurchaseSys.addItem(FFPItemRegistry.CHICA_SYRUP, 3);
        PurchaseSys.addItem(FFPItemRegistry.CLASSIC_CPU, 6);
        ((FFPEvents.RegisterItems)FFPEvents.PURCHASE_REGISTRY.invoker()).register().forEach(purchasableItem -> PurchaseSys.addItem(purchasableItem.suppliedItem, purchasableItem.price));
    }

    public static HashMap<Integer, PurchasableItem> items() {
        return new HashMap<Integer, PurchasableItem>((Map<Integer, PurchasableItem>)ITEMS);
    }

    public static void addItem(Supplier<Item> itemSupplier, int price) {
        ITEMS.put(ITEMS.size(), (Object)new PurchasableItem(itemSupplier, price));
    }

    public void handleMessage(ScreenScheme.ScreenMessage message) {
        CompoundTag compoundTag = message.tag();
        if (!compoundTag.contains("items")) {
            return;
        }
        ArrayList<Pair<PurchasableItem, Integer>> purchasing = new ArrayList<Pair<PurchasableItem, Integer>>();
        for (Tag cartTag : compoundTag.getList("items", 10)) {
            CompoundTag nbt = (CompoundTag)cartTag;
            int id = nbt.getInt("id");
            int count = nbt.getInt("count");
            if (!ITEMS.containsKey(id) || count < 0) continue;
            purchasing.add((Pair<PurchasableItem, Integer>)Pair.of((Object)((PurchasableItem)ITEMS.get(id)), (Object)count));
        }
        Component component = this.handlePurchase(purchasing);
        CompoundTag response = new CompoundTag();
        response.putString("response", Component.Serializer.toJson((Component)component, (HolderLookup.Provider)this.player.level().registryAccess()));
        this.sendNbt(response);
    }

    public record PurchasableItem(Supplier<Item> suppliedItem, int price) {
        public Item item() {
            return this.suppliedItem.get();
        }

        public String name() {
            return Component.translatable((String)this.item().getDescriptionId()).getString();
        }
    }
}

