/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage;

import foundry.veil.platform.VeilEventPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.mudhut.ffpackage.client.gui.CatalogScreen;
import net.mudhut.ffpackage.level.item.components.FlashlightStateComponents;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.server.purchase.PurchaseSys;
import net.mudhut.ffpackage.util.PlayerFlashlights;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.refractionapi.refraction.feature.scheme.ScreenRegistry;

@Mod(value="ffpackage", dist={Dist.CLIENT})
public class FFPackageClient {
    private static final HashMap<UUID, PlayerFlashlights> flashlights = new HashMap();

    public FFPackageClient(IEventBus eventBus, ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        this.registerSelf();
        this.handleVeil();
    }

    public void registerSelf() {
        ScreenRegistry.register(PurchaseSys.class, CatalogScreen.class);
    }

    public void handleVeil() {
        VeilEventPlatform.INSTANCE.onVeilRenderLevelStage((stage, levelRenderer, bufferSource, matrixStack, matrix4fc, matrix4fc1, i, deltaTracker, camera, frustum) -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            ArrayList<UUID> removeFlashlights = new ArrayList<UUID>(flashlights.keySet());
            for (Player player : Minecraft.getInstance().level.players()) {
                FlashlightStateComponents dataComponent;
                if (!player.getMainHandItem().is(FFPItemRegistry.FLASHLIGHT) && !player.getOffhandItem().is(FFPItemRegistry.FLASHLIGHT) || (dataComponent = player.getMainHandItem().is(FFPItemRegistry.FLASHLIGHT) ? (FlashlightStateComponents)player.getMainHandItem().get(FFPDataComponents.FLASHLIGHT) : (FlashlightStateComponents)player.getOffhandItem().get(FFPDataComponents.FLASHLIGHT)) == null) continue;
                boolean isOn = dataComponent.isOn();
                PlayerFlashlights playerFlashlights = flashlights.computeIfAbsent(player.getUUID(), uuid -> new PlayerFlashlights());
                if (!isOn) continue;
                playerFlashlights.updateFlashlights(player, deltaTracker);
                removeFlashlights.remove(player.getUUID());
            }
            for (UUID uuid2 : removeFlashlights) {
                flashlights.get(uuid2).removeFlashlights();
                flashlights.remove(uuid2);
            }
        });
    }
}

