/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.components.TextImageButton;
import net.mudhut.ffpackage.registries.FFPCatalogShops;
import net.mudhut.ffpackage.registries.FFPCatalogTabs;
import net.mudhut.ffpackage.registries.FFPRegistries;
import net.mudhut.ffpackage.server.purchase.PurchaseSys;
import net.mudhut.ffpackage.util.CatalogTab;
import net.mudhut.ffpackage.util.CatalogTabShop;
import net.refractionapi.refraction.feature.scheme.RScreen;
import net.refractionapi.refraction.feature.scheme.RegisterScreen;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;

@RegisterScreen(value=PurchaseSys.class)
public class CatalogScreen
extends Screen
implements RScreen {
    public static final ResourceLocation CATALOG_BACKGROUND = FFPackage.resource("textures/gui/catalog_menu.png");
    public static final ResourceLocation CART_SPRITE = FFPackage.resource("catalog/catalog_cart_list");
    public static final List<CatalogTab> catalogTabs = FFPRegistries.CATALOG_TABS.stream().toList();
    private final Int2ObjectArrayMap<PurchaseSys.PurchasableItem> itemCatalog;
    public List<CatalogTabShop> tabShops = NonNullList.create();
    public final List<Button> shopItemButtons = new ArrayList<Button>();
    public final List<Button> catalogShopButtons = new ArrayList<Button>();
    public final List<Button> catalogTabButtons = new ArrayList<Button>();
    public static CatalogTab selectedTab = FFPCatalogTabs.ANIMATRONIC_TAB.get();
    public static CatalogTabShop selectedShop = FFPCatalogShops.BUDGET_TECH.get();
    public final Cart cart = new Cart();
    public PurchaseSys.PurchasableItem selectedItem = null;
    int msgTime = 0;
    int currentScroll = 0;
    Component msg = null;

    public CatalogScreen(Int2ObjectArrayMap<PurchaseSys.PurchasableItem> itemCatalog) {
        super((Component)Component.literal((String)"Purchase"));
        this.itemCatalog = itemCatalog;
        for (CatalogTab catalogTab : catalogTabs) {
            for (CatalogTabShop tabShop : catalogTab.getTabShops()) {
                tabShop.getShopItems().clear();
                itemCatalog.forEach((i, item) -> {
                    if (tabShop.literalID().equals(item.tabOwner())) {
                        tabShop.getShopItems().add((PurchaseSys.PurchasableItem)item);
                    }
                });
            }
        }
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 - 143, this.height / 2 + 58, 16, 16, new WidgetSprites(FFPackage.resource("catalog/scroll_down_unselected"), FFPackage.resource("catalog/scroll_down_selected")), btn -> {
            if (this.currentScroll != this.shopItemButtons.size() - 8) {
                if (this.shopItemButtons.size() < 8) {
                    return;
                }
                ++this.currentScroll;
                for (int size = 0; size < selectedShop.getShopItems().size(); ++size) {
                    Button shopItemButton = this.shopItemButtons.get(size);
                    shopItemButton.setY(shopItemButton.getY() - 18);
                    shopItemButton.visible = size <= this.currentScroll + 7 && size >= this.currentScroll;
                }
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 - 143, this.height / 2 + 40, 16, 16, new WidgetSprites(FFPackage.resource("catalog/scroll_up_unselected"), FFPackage.resource("catalog/scroll_up_selected")), btn -> {
            if (this.currentScroll != 0) {
                --this.currentScroll;
                for (int size = 0; size < selectedShop.getShopItems().size(); ++size) {
                    Button shopItemButton = this.shopItemButtons.get(size);
                    shopItemButton.setY(shopItemButton.getY() + 18);
                    shopItemButton.visible = size <= this.currentScroll + 7 && size >= this.currentScroll;
                }
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 + 14, this.height / 2 + 44, 79, 19, new WidgetSprites(FFPackage.resource("catalog/add_to_cart_button_unselected"), FFPackage.resource("catalog/add_to_cart_button_selected")), btn -> {
            if (this.selectedItem != null) {
                if (this.cart.items.size() < 12) {
                    this.cart.addItem(this.selectedItem.getId(), 1);
                } else if (this.cart.items.containsKey(this.selectedItem.getId())) {
                    this.cart.addItem(this.selectedItem.getId(), 1);
                }
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 + 100, this.height / 2 + 44, 19, 19, new WidgetSprites(FFPackage.resource("catalog/remove_from_cart_button_unselected"), FFPackage.resource("catalog/remove_from_cart_button_selected")), btn -> {
            if (this.selectedItem != null && this.cart.items.get(this.selectedItem.getId()) != null && this.cart.items.get(this.selectedItem.getId()) > 0) {
                this.cart.addItem(this.selectedItem.getId(), -1);
            }
        }));
        catalogTabs.forEach(catalogTab -> this.catalogTabButtons.add((Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 - 127 + this.catalogTabButtons.size() * 33, this.height / 2 + 70, 33, 47, new WidgetSprites(catalogTab.getTabSprite()[0], catalogTab.getTabSprite()[1]), onPress -> this.setTab((CatalogTab)catalogTab)))));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 + 130, this.height / 2 + 24, 80, 19, new WidgetSprites(FFPackage.resource("catalog/cart_buy_button"), FFPackage.resource("catalog/cart_buy_button_selected")), btn -> this.sendNbt(this.cart.sendBuyRequest())));
        this.setTab(selectedTab);
    }

    private void setTab(CatalogTab tab) {
        this.catalogShopButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.catalogShopButtons.clear();
        this.tabShops = tab.getTabShops();
        if (this.tabShops.isEmpty()) {
            return;
        }
        this.tabShops.forEach(tabShop -> this.catalogShopButtons.add((Button)this.addRenderableWidget((GuiEventListener)new TextImageButton(this.width / 2 - 241, this.height / 2 - 86 + this.catalogShopButtons.size() * 21, 110, 20, new WidgetSprites(tabShop.getTabSprite()[0], tabShop.getTabSprite()[1]), onPress -> this.setShop((CatalogTabShop)tabShop), tabShop.getDisplayName()))));
        this.setShop(this.tabShops.getFirst());
    }

    private void setShop(CatalogTabShop shop) {
        this.shopItemButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.shopItemButtons.clear();
        this.currentScroll = 0;
        if (shop == null) {
            return;
        }
        selectedShop = shop;
        shop.getShopItems().forEach(item -> {
            Object name = item.name();
            if (item.id() == null) {
                return;
            }
            int itemId = item.getId();
            int shopItemId = this.shopItemButtons.size();
            if (((String)name).length() >= 14) {
                name = ((String)name).substring(0, 14) + "...";
            }
            this.shopItemButtons.add(shopItemId, (Button)this.addRenderableWidget((GuiEventListener)new PlainTextButton(this.width / 2 - 100, this.height / 2 - 81 + this.shopItemButtons.size() * 18, 90, 18, (Component)Component.literal((String)name), onPress -> {
                this.selectedItem = this.cart.get(itemId);
            }, this.font)));
            this.shopItemButtons.get((int)shopItemId).visible = false;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY > 0.0 ? this.currentScroll != 0 : this.currentScroll != this.shopItemButtons.size() - 8) {
            if (this.shopItemButtons.size() < 8) {
                return false;
            }
            this.currentScroll = (int)((double)this.currentScroll - scrollY);
            for (int size = 0; size < this.shopItemButtons.size(); ++size) {
                Button shopItemButton = this.shopItemButtons.get(size);
                int itemScroll = (int)((double)shopItemButton.getY() + scrollY * 18.0);
                shopItemButton.setY(itemScroll);
                int shopItemButtonInt = this.shopItemButtons.indexOf(this.shopItemButtons.get(size));
                this.shopItemButtons.get((int)size).visible = shopItemButtonInt <= this.currentScroll + 7 && shopItemButtonInt >= this.currentScroll;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void renderVisible(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.shopItemButtons.size() != selectedShop.getShopItems().size()) {
            return;
        }
        for (int size = 0; size < selectedShop.getShopItems().size(); ++size) {
            boolean flag;
            int shopItem = this.shopItemButtons.indexOf(this.shopItemButtons.get(size));
            boolean bl = flag = shopItem <= this.currentScroll + 7 && shopItem >= this.currentScroll;
            if (flag && this.minecraft != null) {
                guiGraphics.renderFakeItem(selectedShop.getShopItems().get(size).item().getDefaultInstance(), this.width / 2 - 119, this.shopItemButtons.get(size).getY() - 4);
                guiGraphics.drawString(this.font, "$%s".formatted(selectedShop.getShopItems().get(size).price()), this.width / 2 - 9, this.shopItemButtons.get(size).getY(), Color.WHITE.getRGB(), true);
            }
            this.shopItemButtons.get((int)size).visible = flag;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderVisible(guiGraphics, mouseX, mouseY, partialTick);
        int size = 0;
        while (size < catalogTabs.size()) {
            int finalSize = size++;
            catalogTabs.forEach(tabDeferredHolder -> guiGraphics.renderFakeItem(((CatalogTab)catalogTabs.stream().toList().get(finalSize)).getIconItem().get(), this.width / 2 - 118 + finalSize * 33, this.height / 2 + 80));
        }
        this.renderCart(guiGraphics, mouseX, mouseY, partialTick);
        this.renderShopItem(guiGraphics, mouseX, mouseY, partialTick);
        String name = "%s".formatted(selectedShop.getDisplayName().getString());
        guiGraphics.drawString(this.font, name, this.width - 319 - this.font.width(name) / 2, this.height / 2 - 110, Color.BLACK.getRGB(), false);
    }

    public void tick() {
        super.tick();
        int n = this.msgTime = this.msg == null ? 0 : (this.msgTime = this.msgTime + 1);
        this.msg = this.msg != null ? (this.msgTime < 40 ? this.msg : null) : null;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(CART_SPRITE, (this.width + 222) / 2, (this.height - 239) / 2, 123, 165);
        guiGraphics.blit(CATALOG_BACKGROUND, (this.width - 265) / 2, (this.height - 255) / 2, 0, 0, 256, 197);
    }

    public void handle(ScreenScheme.ScreenMessage screenMessage) {
        CompoundTag compoundTag = screenMessage.tag();
        if (!compoundTag.contains("response") || this.getMinecraft().level == null) {
            return;
        }
        this.msg = Component.Serializer.fromJson((String)compoundTag.getString("response"), (HolderLookup.Provider)this.getMinecraft().level.registryAccess());
    }

    public void renderCart(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Iterator<Map.Entry<Integer, Integer>> it = this.cart.items.entrySet().iterator();
        int i = 0;
        if (this.msg != null) {
            guiGraphics.drawString(this.font, this.msg, this.width / 2 + 133, this.height / 2 - 116, Color.BLACK.getRGB(), false);
        }
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            int id = entry.getKey();
            int count = entry.getValue();
            PurchaseSys.PurchasableItem item = this.cart.get(id);
            String itemName = item.name();
            guiGraphics.drawString(this.font, "%s".formatted(count), this.width / 2 + 127, this.height / 2 - 86 + i * 9, Color.BLACK.getRGB(), false);
            if (itemName.length() > 15) {
                itemName = "%s".formatted(itemName.substring(0, 15) + "...");
            }
            guiGraphics.drawString(this.font, itemName, this.width / 2 + 141, this.height / 2 - 86 + i * 9, Color.BLACK.getRGB(), false);
            ++i;
        }
        guiGraphics.drawString(this.font, "Total: $%s".formatted(this.cart.totalPrice()), this.width / 2 + 141, this.height / 2 - 105, Color.BLACK.getRGB(), false);
    }

    public void renderShopItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.selectedItem != null) {
            Object name = this.selectedItem.name();
            if (((String)name).length() > 17) {
                name = ((String)name).substring(0, 17) + "...";
            }
            guiGraphics.drawString(this.font, (String)name, this.width / 2 + 17, this.height / 2 - 88, Color.WHITE.getRGB(), true);
            this.drawWordWrap(guiGraphics, this.font, FormattedText.of((String)this.selectedItem.description()), this.width / 2 + 17, this.height / 2 + 4, 100, Color.WHITE.getRGB(), true);
            guiGraphics.drawString(this.font, "$%s".formatted(this.selectedItem.price()), this.width / 2 + 15, this.height / 2 - 6, Color.WHITE.getRGB());
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(3.0f, 3.0f, 3.0f);
            guiGraphics.renderFakeItem(this.selectedItem.item().getDefaultInstance(), this.width / 2 - 199, this.height / 2 - 131);
            guiGraphics.pose().popPose();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawWordWrap(GuiGraphics guiGraphics, Font font, FormattedText text, int x, int y, int lineWidth, int color, boolean dropShadow) {
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            guiGraphics.drawString(font, formattedcharsequence, x, y, color, dropShadow);
            y += 9;
        }
    }

    public class Cart {
        public final HashMap<Integer, Integer> items = new HashMap();

        public boolean validCount(int count) {
            return count > -256 && count < 256;
        }

        public void addItem(int item, int added) {
            if (!this.validCount(added)) {
                return;
            }
            this.items.compute(item, (count, oldCount) -> {
                int ret = oldCount == null ? added : Math.clamp((long)(oldCount + added), 0, 45);
                return ret == 0 ? null : Integer.valueOf(ret);
            });
        }

        public int totalPrice() {
            return this.items.entrySet().stream().mapToInt(entry -> {
                PurchaseSys.PurchasableItem item = this.get((Integer)entry.getKey());
                return item == null ? 0 : item.price() * (Integer)entry.getValue();
            }).sum();
        }

        public CompoundTag compileCart() {
            CompoundTag tag = new CompoundTag();
            ListTag tags = new ListTag();
            this.items.forEach((id, count) -> {
                CompoundTag purchasable = new CompoundTag();
                purchasable.putInt("id", id.intValue());
                purchasable.putInt("count", count.intValue());
                tags.add((Object)purchasable);
            });
            tag.put("items", (Tag)tags);
            return tag;
        }

        public CompoundTag sendBuyRequest() {
            CompoundTag cart = this.compileCart();
            this.items.clear();
            return cart;
        }

        public PurchaseSys.PurchasableItem get(int item) {
            return (PurchaseSys.PurchasableItem)CatalogScreen.this.itemCatalog.get(item);
        }
    }
}

