/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.components.PlainTextButton;
import net.mudhut.ffpackage.client.gui.components.SwappableImageButton;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.inventory.EndoConfigMenu;
import net.mudhut.ffpackage.level.item.CPUItem;
import net.mudhut.ffpackage.networking.C2S.SetEndoActivePacket;
import net.mudhut.ffpackage.networking.C2S.SetEndoTypePacket;
import net.mudhut.ffpackage.networking.FFPMessages;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import org.apache.commons.lang3.text.WordUtils;

public class EndoConfigScreen
extends AbstractContainerScreen<EndoConfigMenu> {
    public static final ResourceLocation ENDO_BACKGROUND = FFPackage.resource("textures/gui/endo_configuration_menu.png");
    public Component typeMessage;
    public WidgetSprites activeSprites;
    public Endo01 endoSkeleton;
    public SwappableImageButton activeButton;
    public Button typeButton;

    public EndoConfigScreen(EndoConfigMenu menu, Inventory inventory) {
        super((AbstractContainerMenu)menu, inventory, (Component)Component.empty());
        this.endoSkeleton = menu.endoSkeleton;
        this.activeSprites = new WidgetSprites(this.endoSkeleton.isActivated() ? FFPackage.resource("endo_config/endo_switch_up") : FFPackage.resource("endo_config/endo_switch_down"), this.endoSkeleton.isActivated() ? FFPackage.resource("endo_config/endo_switch_up_highlight") : FFPackage.resource("endo_config/endo_switch_down_highlight"));
        this.typeMessage = Component.literal((String)(this.endoSkeleton.getAnimatronicType() == 0 ? "None" : String.valueOf(Math.clamp((long)this.endoSkeleton.getAnimatronicType(), 0, 4)))).withColor(new Color(188, 245, 165).getRGB());
    }

    protected void init() {
        super.init();
        this.activeButton = (SwappableImageButton)this.addRenderableWidget((GuiEventListener)new SwappableImageButton(this.width / 2 - 32, this.height / 2 - 62, 27, 44, this.activeSprites, button -> {
            if (this.endoSkeleton.inventory.getItem(0).getItem() instanceof CPUItem) {
                FFPMessages.sendToServer(new SetEndoActivePacket(this.endoSkeleton.getId(), !this.endoSkeleton.isActivated()));
            } else {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(FFPSoundRegistry.FAILED, (float)1.0f));
            }
        }));
        this.typeButton = (Button)this.addRenderableWidget((GuiEventListener)new PlainTextButton(this.width / 2 + 62, this.height / 2 - 40, 64, 16, this.typeMessage, button -> {
            int animatronicType = this.endoSkeleton.getAnimatronicType() == 4 ? 0 : Math.clamp((long)(this.endoSkeleton.getAnimatronicType() + 1), 0, 4);
            FFPMessages.sendToServer(new SetEndoTypePacket(this.endoSkeleton.getId(), animatronicType));
            this.typeButton.setMessage(this.typeMessage);
        }, this.font));
    }

    protected void containerTick() {
        super.containerTick();
        if (((EndoConfigMenu)this.menu).getSlot(0).getItem().isEmpty()) {
            this.activeSprites = new WidgetSprites(FFPackage.resource("endo_config/endo_switch_down"), FFPackage.resource("endo_config/endo_switch_down_highlight"));
            this.activeButton.setSprites(this.activeSprites);
        }
        this.typeMessage = Component.literal((String)(this.endoSkeleton.getAnimatronicType() == 4 ? "None" : String.valueOf(Math.clamp((long)(this.endoSkeleton.getAnimatronicType() + 1), 0, 4)))).withColor(new Color(188, 245, 165).getRGB());
        this.activeSprites = new WidgetSprites(this.endoSkeleton.isActivated() ? FFPackage.resource("endo_config/endo_switch_up") : FFPackage.resource("endo_config/endo_switch_down"), this.endoSkeleton.isActivated() ? FFPackage.resource("endo_config/endo_switch_up_highlight") : FFPackage.resource("endo_config/endo_switch_down_highlight"));
        this.activeButton.setSprites(this.activeSprites);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Statistics"), this.width / 2 + 14, this.height / 2 - 126, new Color(92, 161, 64).getRGB());
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Set Type:"), this.width / 2 + 14, this.height / 2 - 40, new Color(92, 161, 64).getRGB());
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (this.endoSkeleton.getItemBySlot(equipmentSlot).isEmpty() || equipmentSlot == EquipmentSlot.MAINHAND || equipmentSlot == EquipmentSlot.OFFHAND) continue;
            ItemStack itemStack = this.endoSkeleton.getItemBySlot(equipmentSlot);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"%s Dmg: %s".formatted(WordUtils.capitalize((String)equipmentSlot.getName()), itemStack.getDamageValue())), this.width / 2 + 14, this.height / 2 - 86 - equipmentSlot.getIndex() * 10, new Color(92, 161, 64).getRGB());
        }
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"ENDO HP: %s".formatted((int)(this.endoSkeleton.getHealth() / this.endoSkeleton.getMaxHealth() * 100.0f))), this.width / 2 + 14, this.height / 2 - 76, new Color(92, 161, 64).getRGB());
        ResourceLocation lightLocation = this.endoSkeleton.isActivated() ? FFPackage.resource("endo_config/endo_light_on") : FFPackage.resource("endo_config/endo_light_off");
        guiGraphics.blitSprite(lightLocation, this.width / 2 - 43, this.height / 2 - 91, 8, 8);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(ENDO_BACKGROUND, this.width / 2 - 95, this.height / 2 - 138, 0, 0, 192, 221);
    }
}

