/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.entity.MidnightMotorMachineBlockEntity;
import net.mudhut.ffpackage.level.inventory.MidnightMotoristMachineMenu;
import org.joml.Vector2f;

public class FruityMazeTestScreen
extends AbstractContainerScreen<MidnightMotoristMachineMenu> {
    public static final ResourceLocation BACKGROUND = FFPackage.resource("textures/gui/midnight_motorist_menu.png");
    public static final ResourceLocation PLAYER = FFPackage.resource("midnight_motor/pink_car");
    public static final ResourceLocation MAZE = FFPackage.resource("fruity_maze/maze");
    public final MidnightMotorMachineBlockEntity blockEntity;
    public Vector2f worldOffset = new Vector2f(142.0f, 161.0f);
    public Vector2f playerOffset = new Vector2f(0.0f, 0.0f);
    Rectangle playerCol = new Rectangle();
    Rectangle enemyCol = new Rectangle();
    public boolean downKey = false;
    public boolean upKey = false;
    public boolean leftKey = false;
    public boolean rightKey = false;
    final int carWidth = 7;
    final int carHeight = 5;

    public FruityMazeTestScreen(MidnightMotoristMachineMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.blockEntity = menu.blockEntity;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(BACKGROUND, this.width / 2 - 88, this.height / 2 - 122, 0, 0, 176, 221);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.playerCol.intersects(this.enemyCol)) {
            this.enemyCol = null;
        }
        if (this.downKey) {
            if (this.worldOffset.y < 295.0f && this.playerOffset.y == 0.0f) {
                this.worldOffset = this.worldOffset.add(0.0f, 3.0f);
            } else if (this.playerOffset.y < 30.0f) {
                this.playerOffset = this.playerOffset.add(0.0f, 3.0f);
            }
        } else if (this.upKey) {
            if (this.worldOffset.y > 116.0f && this.playerOffset.y == 0.0f) {
                this.worldOffset = this.worldOffset.sub(0.0f, 3.0f);
            } else if (this.playerOffset.y > -33.0f) {
                this.playerOffset = this.playerOffset.sub(0.0f, 3.0f);
            }
        }
        if (this.rightKey) {
            if (this.worldOffset.x < 175.0f && this.playerOffset.x == 0.0f) {
                this.worldOffset = this.worldOffset.add(3.0f, 0.0f);
            } else if (this.playerOffset.x < 72.0f) {
                this.playerOffset = this.playerOffset.add(3.0f, 0.0f);
            }
        } else if (this.leftKey) {
            if (this.worldOffset.x > 81.0f && this.playerOffset.x == 0.0f) {
                this.worldOffset = this.worldOffset.sub(3.0f, 0.0f);
            } else if (this.playerOffset.x > -69.0f) {
                this.playerOffset = this.playerOffset.sub(3.0f, 0.0f);
            }
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        Options key = Minecraft.getInstance().options;
        if (keyCode == key.keyDown.getKey().getValue()) {
            this.downKey = false;
        } else if (keyCode == key.keyUp.getKey().getValue()) {
            this.upKey = false;
        }
        if (keyCode == key.keyRight.getKey().getValue()) {
            this.rightKey = false;
        } else if (keyCode == key.keyLeft.getKey().getValue()) {
            this.leftKey = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options key = Minecraft.getInstance().options;
        if (keyCode == key.keyJump.getKey().getValue()) {
            FFPackage.LOGGER.info("X: {}, Y: {}", (Object)Float.valueOf(this.worldOffset.x), (Object)Float.valueOf(this.worldOffset.y));
            FFPackage.LOGGER.info("Player X: {}, Player Y: {}", (Object)Float.valueOf(this.playerOffset.x), (Object)Float.valueOf(this.playerOffset.y));
        }
        if (keyCode == key.keyDown.getKey().getValue()) {
            this.downKey = true;
        } else if (keyCode == key.keyUp.getKey().getValue()) {
            this.upKey = true;
        }
        if (keyCode == key.keyRight.getKey().getValue()) {
            this.rightKey = true;
        } else if (keyCode == key.keyLeft.getKey().getValue()) {
            this.leftKey = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void afterKeyboardAction() {
        super.afterKeyboardAction();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int scizWidth;
        int scizY;
        int scizX;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.inventoryLabelY = this.imageHeight - 77;
        RenderSystem.enableBlend();
        int scizHeight = switch ((Integer)Minecraft.getInstance().options.guiScale().get()) {
            case 1 -> {
                scizX = this.width / 2 - 81;
                scizY = this.height / 2 + 39;
                scizWidth = 162;
                yield 78;
            }
            case 2 -> {
                scizX = this.width / 2 + 318;
                scizY = this.height / 2 + 323;
                scizWidth = 324;
                yield 156;
            }
            case 3 -> {
                scizX = this.width / 2 + 398;
                scizY = this.height / 2 + 445;
                scizWidth = 485;
                yield 234;
            }
            default -> {
                scizX = this.width / 2 + 397;
                scizY = this.height / 2 + 523;
                scizWidth = 647;
                yield 311;
            }
        };
        this.enemyCol.setRect((int)((float)this.width / 2.0f + 40.0f - this.worldOffset.x), (int)((float)this.height / 2.0f + 40.0f - this.worldOffset.y), 17.0, 13.0);
        this.playerCol.setRect((int)((float)this.width / 2.0f - 8.0f + this.playerOffset.x), (int)((float)this.height / 2.0f - 82.0f + this.playerOffset.y), 17.0, 13.0);
        BufferedImage bufferedImage = new BufferedImage(256, 256, 1);
        RenderSystem.enableScissor((int)scizX, (int)scizY, (int)scizWidth, (int)scizHeight);
        guiGraphics.blitSprite(MAZE, (int)((float)this.width / 2.0f - this.worldOffset.x), (int)((float)this.height / 2.0f - this.worldOffset.y), 0, 256, 256);
        guiGraphics.blitSprite(PLAYER, this.playerCol.x, this.playerCol.y, this.playerCol.width, this.playerCol.height);
        guiGraphics.blitSprite(PLAYER, this.enemyCol.x, this.enemyCol.y, this.enemyCol.width, this.enemyCol.height);
        RenderSystem.disableScissor();
        guiGraphics.fill(this.playerCol.x, this.playerCol.y, this.playerCol.x + this.playerCol.width, this.playerCol.y + this.playerCol.height, new Color(221, 255, 0).getRGB());
        guiGraphics.fill(this.enemyCol.x, this.enemyCol.y, this.enemyCol.x + this.enemyCol.width, this.enemyCol.y + this.enemyCol.height, new Color(255, 0, 0).getRGB());
    }
}

