/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.components.MidnightMotorCar;
import net.mudhut.ffpackage.level.block.entity.MidnightMotorMachineBlockEntity;
import net.mudhut.ffpackage.level.inventory.MidnightMotoristMachineMenu;
import net.mudhut.ffpackage.networking.C2S.MMBooleanSetPacket;
import net.mudhut.ffpackage.networking.C2S.MMCarsHitPacket;
import net.mudhut.ffpackage.networking.FFPMessages;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import net.refractionapi.refraction.helper.runnable.Runnabler;
import org.joml.Vector2f;

public class MidnightMotoristScreen
extends AbstractContainerScreen<MidnightMotoristMachineMenu> {
    public static final ResourceLocation BACKGROUND = FFPackage.resource("textures/gui/midnight_motorist_menu.png");
    public static final ResourceLocation ROAD = FFPackage.resource("textures/gui/sprites/midnight_motor/road.png");
    public static final ResourceLocation BLACK_LINE = FFPackage.resource("midnight_motor/black_line");
    public static final ResourceLocation FINISH_LINE = FFPackage.resource("textures/gui/sprites/midnight_motor/finish_line.png");
    public static final ResourceLocation COUNT_DOWN_TEXT = FFPackage.resource("textures/gui/sprites/midnight_motor/count_down.png");
    public static final ResourceLocation PURPLE_CAR_TOP = FFPackage.resource("midnight_motor/purple_car_top");
    public static final ResourceLocation PURPLE_CAR_BOTTOM = FFPackage.resource("midnight_motor/purple_car_bottom");
    public static final ResourceLocation PLAYER_CAR = FFPackage.resource("midnight_motor/pink_car");
    public final MidnightMotorMachineBlockEntity blockEntity;
    public final SimpleSoundInstance p240bitsPerMile = new SimpleSoundInstance(FFPSoundRegistry.BITS_PER_MILE.getId(), SoundSource.MASTER, 0.7f, 1.0f, SoundInstance.createUnseededRandom(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    public final SimpleSoundInstance start_count = new SimpleSoundInstance(FFPSoundRegistry.START_COUNT.getId(), SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    public final SimpleSoundInstance lapComplete = new SimpleSoundInstance(FFPSoundRegistry.LAP_COMPLETE.getId(), SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    public final SimpleSoundInstance carCrash = new SimpleSoundInstance(FFPSoundRegistry.CAR_CRASH.getId(), SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    public final List<EnemyCar> enemyCars = new ArrayList<EnemyCar>();
    public final List<PlayerCar> playerCars = new ArrayList<PlayerCar>();
    public final List<LapGoal> lapFinishLines = new ArrayList<LapGoal>();
    public int timer = 0;
    public Button playButton;
    public boolean gameActive = false;
    public boolean isPaused = false;
    public int roadScroll = 0;
    public int lapLineScroll = 0;
    public int scrollSpeed = 1;
    public int countDownOffset = 0;
    public int playerHeight = 13;
    public Vector2f playerPos = new Vector2f(242.0f, 71.0f);
    public boolean completedLap = false;
    public boolean isCounting = false;
    public boolean gameWon = false;
    public boolean playerHit = false;
    public boolean downKey = false;
    public boolean upKey = false;
    public boolean leftKey = false;
    public boolean rightKey = false;
    public int carCounter = 0;
    public int carsHit = 0;
    public int currentLap = 1;
    public int score = 0;
    public int highScore = 0;
    final int carWidth = 7;
    final int carHeight = 5;
    public int gameTick = 0;
    public int countdownTick = 0;
    public int playerTick = 0;
    public int carTick = 0;
    public int lapTick = 0;
    public int containerTick = 0;
    public final int goalSpawn1 = 600;
    public final int goalSpawn2 = 1200;
    public final int goalSpawn3 = 1800;
    public final int boundMaxX = 386;
    public final int boundMinX = 241;
    public final int boundMaxY = 111;
    public final int boundMinY = 50;

    public MidnightMotoristScreen(MidnightMotoristMachineMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.blockEntity = menu.blockEntity;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(BACKGROUND, this.width / 2 - 112, this.height / 2 - 122, 0, 0, 224, 221);
    }

    protected void init() {
        this.playButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Play"), onPress -> {
            this.isCounting = true;
            this.containerTick = 0;
            FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), true, false));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.start_count);
        }).bounds(this.width / 2 - 23, this.height / 2 - 26, 22, 20).build());
        super.init();
    }

    public void spawnCars() {
        int carX;
        int carY;
        RandomSource randomSource = RandomSource.create();
        boolean spawnAtTop = randomSource.nextBoolean();
        if (spawnAtTop) {
            carY = 52;
            carX = 220;
        } else {
            carY = 91;
            carX = 403;
        }
        if (randomSource.nextInt(3) == 0) {
            carY += 18;
        }
        EnemyCar newCar = new EnemyCar(carX, carY, spawnAtTop);
        if (this.carTick >= 40 && this.gameActive && !this.isPaused) {
            this.enemyCars.add(newCar);
            ++this.carCounter;
            this.carTick = randomSource.nextInt(Math.clamp((long)(5 + this.currentLap) * 2L, 5, 24), 25);
        }
    }

    public boolean hitCar(EnemyCar car, int x, int y) {
        int enemyMinX = x - 7;
        int enemyMinY = y - 5;
        int enemyMaxX = x + 7;
        int enemyMaxY = y + 5;
        int minX = (int)this.playerPos.x - 7;
        int minY = (int)this.playerPos.y - 5;
        int maxX = (int)this.playerPos.x + 7;
        int maxY = (int)this.playerPos.y + 5;
        return enemyMaxX >= minX && enemyMinX <= maxX && enemyMaxY >= minY && enemyMinY <= maxY;
    }

    public void gameReset() {
        this.timer = 0;
        this.gameActive = false;
        FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), false, false));
        this.playerHit = false;
        this.isPaused = false;
        this.roadScroll = 0;
        this.lapLineScroll = 0;
        this.scrollSpeed = 1;
        this.countDownOffset = 0;
        this.playerHeight = 13;
        this.playerPos = new Vector2f(242.0f, 71.0f);
        this.completedLap = false;
        this.isCounting = false;
        this.gameWon = false;
        FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), false, true));
        this.currentLap = 1;
        this.score = 0;
        this.highScore = 0;
        this.gameTick = 0;
        this.countdownTick = 0;
        this.playerTick = 0;
        this.carTick = 0;
        this.lapTick = 0;
        this.containerTick = 0;
        this.playButton.active = false;
    }

    protected void containerTick() {
        super.containerTick();
        if (this.score > this.highScore) {
            this.highScore = this.score;
        }
        this.playButton.active = ((MidnightMotoristMachineMenu)this.menu).getSlot(0).getItem().is(FFPItemRegistry.FAZ_TOKEN);
        Iterator<PlayerCar> playerCarIterator = this.playerCars.iterator();
        if (!playerCarIterator.hasNext()) {
            this.playerCars.add(new PlayerCar((int)this.playerPos.x, (int)this.playerPos.y));
        }
        ++this.containerTick;
        if (this.isCounting) {
            ++this.countdownTick;
            if (this.containerTick == 100) {
                this.gameActive = true;
                this.isCounting = false;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.p240bitsPerMile);
            }
            if (this.countdownTick % 30 == 0) {
                this.countDownOffset += 30;
            }
        }
        if (this.gameActive) {
            this.playButton.active = false;
            if (!this.isPaused) {
                Iterator<LapGoal> lapGoalIterator;
                ++this.timer;
                ++this.carTick;
                ++this.gameTick;
                ++this.playerTick;
                ++this.lapTick;
                if (this.downKey && this.playerPos.y <= 111.0f) {
                    this.playerPos = this.playerPos.add(0.0f, (float)Math.min(this.scrollSpeed, 4));
                } else if (this.upKey && this.playerPos.y >= 50.0f) {
                    this.playerPos = this.playerPos.sub(0.0f, (float)Math.min(this.scrollSpeed, 4));
                }
                if (this.rightKey && this.playerPos.x <= 386.0f) {
                    this.playerPos = this.playerPos.add((float)Math.min(this.scrollSpeed, 4), 0.0f);
                } else if (this.leftKey && this.playerPos.x >= 241.0f) {
                    this.playerPos = this.playerPos.sub((float)Math.min(this.scrollSpeed, 4), 0.0f);
                }
                if (this.gameTick == 47) {
                    if (this.scrollSpeed < 7) {
                        this.scrollSpeed = Mth.lerpInt((float)this.scrollSpeed, (int)1, (int)2);
                    }
                    this.gameTick = 0;
                }
                this.roadScroll += this.scrollSpeed;
                if (this.scrollSpeed >= 5) {
                    ++this.score;
                }
                this.spawnCars();
                Iterator<EnemyCar> enemyCarIterator = this.enemyCars.iterator();
                while (enemyCarIterator.hasNext() && playerCarIterator.hasNext()) {
                    EnemyCar car = enemyCarIterator.next();
                    if (car.spawnAtTop) {
                        car.x = car.x + this.scrollSpeed - 1;
                        if (car.x >= 406) {
                            enemyCarIterator.remove();
                        }
                    } else {
                        car.x = car.x - this.scrollSpeed + 1;
                        if (car.x <= 217) {
                            enemyCarIterator.remove();
                        }
                    }
                    if (this.hitCar(car, car.x, car.y) && this.playerTick >= 12) {
                        this.scrollSpeed = 2;
                        this.playerTick = 0;
                        this.playerHit = true;
                        ++this.carsHit;
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)this.carCrash);
                        enemyCarIterator.remove();
                    }
                    if (this.playerHit) {
                        FFPackage.LOGGER.info("player hit");
                        this.playerHeight = 0;
                        if (this.playerTick % 2 == 0) {
                            this.playerHeight = 13;
                        }
                        if (this.playerTick < 10) continue;
                        this.playerHit = false;
                        continue;
                    }
                    this.playerHeight = 13;
                }
                if (this.lapTick == 600 || this.lapTick == 1200 || this.lapTick == 1800) {
                    this.lapFinishLines.add(new LapGoal(481));
                }
                if ((lapGoalIterator = this.lapFinishLines.iterator()).hasNext()) {
                    LapGoal goal = lapGoalIterator.next();
                    goal.x -= this.scrollSpeed;
                    this.lapLineScroll = goal.x;
                    if (goal.x <= 241 || (float)goal.x <= this.playerPos.x) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)this.lapComplete);
                        if (this.currentLap < 4) {
                            ++this.currentLap;
                            this.completedLap = true;
                            lapGoalIterator.remove();
                            if (enemyCarIterator.hasNext()) {
                                this.enemyCars.clear();
                            }
                        }
                    }
                }
                if (this.currentLap >= 4) {
                    if (enemyCarIterator.hasNext()) {
                        this.enemyCars.clear();
                    }
                    Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.p240bitsPerMile);
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)this.lapComplete);
                    this.gameActive = false;
                    FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), false, false));
                    this.gameWon = true;
                    FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), true, true));
                    FFPMessages.sendToServer(new MMCarsHitPacket(this.carsHit, this.carCounter));
                    Runnabler.create().delayRun(290, runnabler -> {
                        this.gameWon = false;
                        FFPMessages.sendToServer(new MMBooleanSetPacket(this.blockEntity.getBlockPos(), false, true));
                        this.gameReset();
                    });
                }
                if (this.completedLap) {
                    Runnabler.create().delayRun(30, runnabler -> {
                        this.completedLap = false;
                    });
                }
            }
        } else {
            this.enemyCars.clear();
            this.score = this.highScore;
        }
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        Options key = Minecraft.getInstance().options;
        if (keyCode == key.keyDown.getKey().getValue()) {
            this.downKey = false;
        } else if (keyCode == key.keyUp.getKey().getValue()) {
            this.upKey = false;
        }
        if (keyCode == key.keyRight.getKey().getValue()) {
            this.rightKey = false;
        } else if (keyCode == key.keyLeft.getKey().getValue()) {
            this.leftKey = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options key = Minecraft.getInstance().options;
        if (this.gameActive && !this.isPaused) {
            if (keyCode == key.keyDown.getKey().getValue() && this.playerPos.y <= 111.0f) {
                this.downKey = true;
            } else if (keyCode == key.keyUp.getKey().getValue() && this.playerPos.y >= 50.0f) {
                this.upKey = true;
            }
            if (keyCode == key.keyRight.getKey().getValue() && this.playerPos.x <= 386.0f) {
                this.rightKey = true;
            } else if (keyCode == key.keyLeft.getKey().getValue() && this.playerPos.x >= 241.0f) {
                this.leftKey = true;
            }
        }
        if (keyCode == key.keyDrop.getKey().getValue()) {
            FFPackage.LOGGER.info("Counting Number = {} X = {}, Y = {}, Scroll speed = {}, Lap Goal X = {}", new Object[]{this.countDownOffset, Float.valueOf(this.playerPos.x), Float.valueOf(this.playerPos.y), this.roadScroll, this.lapLineScroll});
        }
        if (keyCode == key.keyJump.getKey().getValue() && this.gameActive) {
            boolean bl = this.isPaused = !this.isPaused;
            if (this.isPaused) {
                Minecraft.getInstance().getSoundManager().pause();
            } else {
                Minecraft.getInstance().getSoundManager().resume();
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void afterKeyboardAction() {
        super.afterKeyboardAction();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.inventoryLabelY = this.imageHeight - 77;
        Iterator<EnemyCar> enemyCarIterator = this.enemyCars.iterator();
        Iterator<PlayerCar> playerCarIterator = this.playerCars.iterator();
        Iterator<LapGoal> lapGoalIterator = this.lapFinishLines.iterator();
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(this.isPaused ? "GAME PAUSED" : "")).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED), this.width / 2 - 35, this.height / 2 - 91, 0xFFFFFF);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("" + this.score)), this.width / 2 + 56, this.height / 2 - 114, 0xFFFFFF);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(this.gameWon ? "GOAL" : "")).withStyle(ChatFormatting.BOLD), this.width / 2 - 14, this.height / 2 - 71, 0xFFFFFF);
        if (this.gameActive) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("LAP " + this.currentLap)), this.width / 2 - 79, this.height / 2 - 114, 0xFFFFFF);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("MPH " + (this.scrollSpeed * 29 - 3))), this.width / 2 - 79, this.height / 2 - 105, 0xFFFFFF);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(this.completedLap ? "LAP" : "")).withStyle(ChatFormatting.BOLD), this.width / 2 - 14, this.height / 2 - 71, 0xFFFFFF);
        } else {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"WASD"), this.width / 2 - 80, this.height / 2 - 46, 0xFFFFFF);
        }
        guiGraphics.blit(ROAD, this.width / 2 - 81, this.height / 2 - 116, this.roadScroll, 0, 162, 78);
        if (this.isCounting) {
            guiGraphics.blit(COUNT_DOWN_TEXT, this.width / 2 - 23, this.height / 2 - 92, 0, this.countDownOffset, 45, 30);
        }
        RenderSystem.enableBlend();
        guiGraphics.enableScissor(this.width / 2 - 81, this.height / 2 - 116, this.width / 2 - 81 + 162, this.height / 2 - 116 + 78);
        while (lapGoalIterator.hasNext()) {
            LapGoal lapGoal = lapGoalIterator.next();
            guiGraphics.blit(FINISH_LINE, this.width / 2 - 322 + lapGoal.x, this.height / 2 - 116, 0, 0, 12, 78);
        }
        while (enemyCarIterator.hasNext()) {
            EnemyCar car = enemyCarIterator.next();
            guiGraphics.blitSprite(car.spawnAtTop ? PURPLE_CAR_TOP : PURPLE_CAR_BOTTOM, this.width / 2 - 322 + car.x, this.height / 2 - 164 + car.y, 0, 17, 13);
        }
        while (playerCarIterator.hasNext()) {
            PlayerCar playerCar = playerCarIterator.next();
            guiGraphics.blitSprite(PLAYER_CAR, (int)((float)this.width / 2.0f - 322.0f + this.playerPos.x), (int)((float)this.height / 2.0f - 164.0f + this.playerPos.y), 0, 17, this.playerHeight);
        }
        RenderSystem.disableScissor();
        guiGraphics.blitSprite(BLACK_LINE, this.width / 2 - 81, this.height / 2 - 116, 162, 78);
    }

    public void onClose() {
        super.onClose();
        this.gameReset();
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.p240bitsPerMile);
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.carCrash);
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.start_count);
        Minecraft.getInstance().getSoundManager().stop((SoundInstance)this.lapComplete);
    }

    private static class EnemyCar
    extends MidnightMotorCar {
        int x;
        int y;
        boolean spawnAtTop;

        public EnemyCar(int x, int y, boolean spawnAtTop) {
            super(x, y, spawnAtTop);
            this.x = x;
            this.y = y;
            this.spawnAtTop = spawnAtTop;
        }
    }

    private static class PlayerCar
    extends MidnightMotorCar {
        public PlayerCar(int x, int y) {
            super(x, y, false);
        }
    }

    private static class LapGoal {
        int x;

        public LapGoal(int x) {
            this.x = x;
        }
    }
}

