/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.components.PlayTapeButton;
import net.mudhut.ffpackage.level.block.entity.ShowtapeTerminalBlockEntity;
import net.mudhut.ffpackage.level.inventory.ShowtapeTerminalMenu;
import net.mudhut.ffpackage.level.item.ShowtapeItem;
import net.mudhut.ffpackage.networking.C2S.ShowtapeTerminalPacket;
import net.mudhut.ffpackage.networking.FFPMessages;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;

public class ShowtapeTerminalScreen
extends AbstractContainerScreen<ShowtapeTerminalMenu> {
    public static final ResourceLocation SHOWTAPE_BACKGROUND = FFPackage.resource("textures/gui/showtape_terminal_menu.png");
    public final ShowtapeTerminalBlockEntity blockEntity;
    public PlayTapeButton activeButton;

    public ShowtapeTerminalScreen(ShowtapeTerminalMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.blockEntity = menu.blockEntity;
    }

    protected void init() {
        super.init();
        this.activeButton = (PlayTapeButton)this.addRenderableWidget((GuiEventListener)new PlayTapeButton(this.width / 2 - 59, this.height / 2 - 37, press -> {
            if (((ShowtapeTerminalMenu)this.menu).getSlot(0).hasItem()) {
                this.blockEntity.isActive = !this.blockEntity.isActive;
                FFPMessages.sendToServer(new ShowtapeTerminalPacket(this.blockEntity.getBlockPos(), this.blockEntity.isActive));
                this.activeButton.setPlay(!this.blockEntity.isActive);
            } else {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(FFPSoundRegistry.FAILED, (float)1.0f));
            }
        }));
    }

    protected void containerTick() {
        super.containerTick();
        if (!((ShowtapeTerminalMenu)this.menu).getSlot(0).hasItem() && this.blockEntity.isActive) {
            this.activeButton.setPlay(true);
            this.activeButton.active = false;
            FFPMessages.sendToServer(new ShowtapeTerminalPacket(this.blockEntity.getBlockPos(), false));
        } else {
            this.activeButton.setPlay(!this.blockEntity.isActive);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Order"), this.width / 2 - 32, this.height / 2 - 96, new Color(33, 139, 51).getRGB(), false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Showtapes"), this.width / 2 + 2, this.height / 2 - 95, new Color(33, 139, 51).getRGB(), false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Active:"), this.width / 2 + 2, this.height / 2 - 82, new Color(33, 139, 51).getRGB(), false);
        if (((ShowtapeTerminalMenu)this.menu).getSlot(0).hasItem()) {
            String showtapeName = ((ShowtapeItem)((ShowtapeTerminalMenu)this.menu).getSlot((int)0).getItem().getItem()).songName;
            if (showtapeName.length() > 11) {
                showtapeName = "%s".formatted(showtapeName.substring(0, 11) + "...");
            }
            guiGraphics.drawString(this.font, (Component)Component.literal((String)showtapeName), this.width / 2 + 2, this.height / 2 - 72, new Color(33, 139, 51).getRGB(), false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"State:"), this.width / 2 + 2, this.height / 2 - 62, new Color(33, 139, 51).getRGB(), false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)(this.blockEntity.isActive ? "Playing" : "Stopped")), this.width / 2 + 2, this.height / 2 - 52, new Color(33, 139, 51).getRGB(), false);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"None"), this.width / 2 + 2, this.height / 2 - 72, new Color(33, 139, 51).getRGB(), false);
        }
        this.inventoryLabelY = this.height / 2 - 69;
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(SHOWTAPE_BACKGROUND, this.width / 2 - 90, this.height / 2 - 112, 0, 0, 180, 218);
    }
}

