/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.item.PlushSuitItem;

public class SuitHeadOverlay {
    public static void render(GuiGraphics guiGraphics, DeltaTracker tracker) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        ItemStack stack = Minecraft.getInstance().player.getItemBySlot(EquipmentSlot.HEAD);
        if (!(stack.getItem() instanceof PlushSuitItem) || Minecraft.getInstance().gameRenderer.getMainCamera().isDetached()) {
            return;
        }
        SuitHeadOverlay.renderTextureOverlay(guiGraphics, FFPackage.resource("textures/overlay/suit_head_overlay.png"), 1.0f, screenWidth, screenHeight);
    }

    public static void renderTextureOverlay(GuiGraphics guiGraphics, ResourceLocation location, float alpha, int screenWidth, int screenHeight) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.enableBlend();
        guiGraphics.blit(location, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

