/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.FFPModelLayers;
import net.mudhut.ffpackage.level.block.BalloonBlock;
import net.mudhut.ffpackage.level.block.entity.BalloonBlockEntity;

public class BalloonRenderer
implements BlockEntityRenderer<BalloonBlockEntity> {
    public static final ResourceLocation BALLOON = FFPackage.resource("textures/entity/white_balloon.png");
    private final ModelPart balloon1;
    private final ModelPart balloon2;
    private final ModelPart balloon3;
    private final ModelPart balloon4;

    public BalloonRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart base = context.bakeLayer(FFPModelLayers.BALLOON);
        this.balloon1 = base.getChild("balloon1");
        this.balloon2 = base.getChild("balloon2");
        this.balloon3 = base.getChild("balloon3");
        this.balloon4 = base.getChild("balloon4");
    }

    public static LayerDefinition createBalloonLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition balloon1 = partdefinition.addOrReplaceChild("balloon1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -23.0f, 0.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition balloon2 = partdefinition.addOrReplaceChild("balloon2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -25.0f, -7.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition balloon3 = partdefinition.addOrReplaceChild("balloon3", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -21.0f, -6.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition balloon4 = partdefinition.addOrReplaceChild("balloon4", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -24.0f, -1.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(BalloonBlockEntity balloonBlockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (balloonBlockEntity.getLevel() == null) {
            return;
        }
        int variant = (Integer)balloonBlockEntity.getBlockState().getValue((Property)BalloonBlock.VARIANT);
        Direction direction = (Direction)balloonBlockEntity.getBlockState().getValue((Property)BalloonBlock.FACING);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)BALLOON));
        if (variant == 0) {
            poseStack.translate(0.31f, -1.375f, 0.25f);
        } else {
            poseStack.translate(0.5f, -1.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - direction.toYRot()));
        }
        this.balloon1.render(poseStack, vertexConsumer, packedLight, packedOverlay, DyeColor.byId((int)balloonBlockEntity.getColor(1)).getTextureDiffuseColor());
        if (variant >= 1) {
            this.balloon2.render(poseStack, vertexConsumer, packedLight, packedOverlay, DyeColor.byId((int)balloonBlockEntity.getColor(2)).getTextureDiffuseColor());
        }
        if (variant >= 2) {
            this.balloon3.render(poseStack, vertexConsumer, packedLight, packedOverlay, DyeColor.byId((int)balloonBlockEntity.getColor(3)).getTextureDiffuseColor());
        }
        if (variant >= 3) {
            this.balloon4.render(poseStack, vertexConsumer, packedLight, packedOverlay, DyeColor.byId((int)balloonBlockEntity.getColor(4)).getTextureDiffuseColor());
        }
        this.balloon1.zRot = 3.14f;
        this.balloon2.zRot = 3.14f;
        this.balloon3.zRot = 3.14f;
        this.balloon4.zRot = 3.14f;
    }
}

