/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.FFPModelLayers;
import net.mudhut.ffpackage.level.block.CardboardCutoutBlock;
import net.mudhut.ffpackage.level.block.entity.CardboardCutoutBlockEntity;

public class CardboardCutoutRenderer
implements BlockEntityRenderer<CardboardCutoutBlockEntity> {
    public static final ResourceLocation CARDBOARD_CUTOUT = FFPackage.resource("textures/entity/bonnie_cutout.png");
    private final ModelPart bone;

    public CardboardCutoutRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(FFPModelLayers.CARDBOARD_CUTOUT);
        this.bone = modelpart.getChild("bone");
    }

    public static LayerDefinition createCutoutLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -32.0f, -2.0f, 20.0f, 32.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(50, -7).addBox(0.0f, -13.0f, -2.0f, 0.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(CardboardCutoutBlockEntity cardboardCutoutBlockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate = cardboardCutoutBlockEntity.getBlockState();
        poseStack.translate(0.5, -1.58, 0.5);
        poseStack.scale(1.05f, 1.05f, 1.05f);
        float rotation = -RotationSegment.convertToDegrees((int)((Integer)blockstate.getValue((Property)CardboardCutoutBlock.ROTATION)));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)((CardboardCutoutBlock)blockstate.getBlock()).getCutoutTexture()));
        this.bone.setRotation(0.0f, 0.0f, 3.14f);
        this.bone.render(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
    }
}

