/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.FFPModelLayers;
import net.mudhut.ffpackage.level.block.RedstoneSpotlightBlock;
import net.mudhut.ffpackage.level.block.entity.RedstoneSpotlightBlockEntity;

public class VintageSpotlightRenderer
implements BlockEntityRenderer<RedstoneSpotlightBlockEntity> {
    public static final ResourceLocation SPOTLIGHT_LIGHT = FFPackage.resource("textures/entity/redstone_spotlight.png");
    public static final ResourceLocation SPOTLIGHT_LIGHT_LAYER = FFPackage.resource("textures/entity/redstone_spotlight_layer.png");
    private final ModelPart spotlight;
    private final ModelPart base;
    private final ModelPart root;

    public VintageSpotlightRenderer(BlockEntityRendererProvider.Context context) {
        this.root = context.bakeLayer(FFPModelLayers.REDSTONE_SPOTLIGHT);
        this.spotlight = this.root.getChild("spotlight");
        this.base = this.root.getChild("base");
    }

    public static LayerDefinition createSpotlightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition spotlight = partdefinition.addOrReplaceChild("spotlight", CubeListBuilder.create().texOffs(4, 18).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition cube_r1 = spotlight.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 2).addBox(0.0f, -3.0f, -4.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r2 = spotlight.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, -4).addBox(0.0f, -3.0f, -4.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r3 = spotlight.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-4, 14).addBox(-3.0f, 0.0f, -4.0f, 6.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-6.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = spotlight.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-4, 14).addBox(-3.0f, 0.0f, -4.0f, 6.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-6.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(28, -2).addBox(3.5f, -6.0f, -1.0f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 6).addBox(-3.5f, -6.0f, -1.0f, 7.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, -2).addBox(-3.5f, -6.0f, -1.0f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(RedstoneSpotlightBlockEntity vintageSpotlightBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = vintageSpotlightBlockEntity.getBlockState();
        if (((Boolean)blockState.getValue((Property)RedstoneSpotlightBlock.HANGING)).booleanValue()) {
            this.root.setRotation(0.0f, 0.0f, 0.0f);
            poseStack.translate(0.0f, -2.26f, 0.0f);
        } else {
            this.root.setRotation(0.0f, 0.0f, 3.14f);
            poseStack.translate(0.0f, -0.26f, 0.0f);
        }
        poseStack.translate(0.5, 1.76, 0.5);
        this.spotlight.setRotation(-0.52f, 0.0f, 0.0f);
        float rotation = -RotationSegment.convertToDegrees((int)((Integer)blockState.getValue((Property)RedstoneSpotlightBlock.ROTATION)));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        this.root.render(poseStack, multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)SPOTLIGHT_LIGHT)), packedLight, packedOverlay, -1);
        if (((Boolean)blockState.getValue((Property)RedstoneSpotlightBlock.LIT)).booleanValue()) {
            this.root.render(poseStack, multiBufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)SPOTLIGHT_LIGHT_LAYER)), packedLight, packedOverlay, vintageSpotlightBlockEntity.colorId);
        }
    }
}

