/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.mudhut.ffpackage.level.block.AssemblyStandBlock;
import net.mudhut.ffpackage.level.block.BalloonBlock;
import net.mudhut.ffpackage.level.block.CardboardBoxBlock;
import net.mudhut.ffpackage.level.block.FluorescentLampBlock;
import net.mudhut.ffpackage.level.block.HangingCloudChainBlock;
import net.mudhut.ffpackage.level.block.HangingStarsChainBlock;
import net.mudhut.ffpackage.level.block.StainedRedstoneLampBlock;
import net.mudhut.ffpackage.level.block.TomatoBushBlock;
import net.mudhut.ffpackage.level.block.TrashPileBlock;
import net.mudhut.ffpackage.level.block.WallPapersBlock;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FFPBlockLootTables
extends BlockLootSubProvider {
    public FFPBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        for (DeferredHolder registry : FFPDecorBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof HangingCloudChainBlock) {
                this.dropOther((Block)registry.get(), (ItemLike)FFPDecorBlockRegistry.WOOD_CLOUD.get());
                continue;
            }
            if (registry.get() instanceof HangingStarsChainBlock) {
                this.dropOther((Block)registry.get(), (ItemLike)FFPDecorBlockRegistry.HANGING_STARS.get());
                continue;
            }
            if (registry.get() instanceof WallPapersBlock || registry.get() instanceof TrashPileBlock) {
                this.add((Block)registry.get(), this.createVariantTable((Block)registry.get()));
                continue;
            }
            if (registry.get() instanceof BalloonBlock) {
                this.add((Block)registry.get(), FFPBlockLootTables.noDrop());
                continue;
            }
            this.dropSelf((Block)registry.get());
        }
        for (DeferredHolder registry : FFPPizzeriaBlocks.BLOCKS.getEntries()) {
            if (registry.get() instanceof StainedRedstoneLampBlock || registry.get() instanceof FluorescentLampBlock) {
                this.dropWhenSilkTouch((Block)registry.get());
                continue;
            }
            if (registry.get() instanceof CardboardBoxBlock) {
                this.add((Block)registry.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)registry.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)registry.get())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include((DataComponentType)FFPDataComponents.CARDBOARD_BOX_ITEM.get()))))));
                continue;
            }
            this.dropSelf((Block)registry.get());
        }
        for (DeferredHolder registry : FFPBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof TomatoBushBlock) {
                this.add((Block)registry.get(), this.createCropDrops((Block)registry.get(), FFPItemRegistry.TOMATO.asItem(), FFPItemRegistry.TOMATO_SEEDS.asItem(), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)FFPBlockRegistry.TOMATO_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TomatoBushBlock.AGE, 3))));
                continue;
            }
            if (registry.get() instanceof AssemblyStandBlock) {
                this.add((Block)registry.get(), this.createSinglePropConditionTable((Block)registry.get(), (Property)AssemblyStandBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
                continue;
            }
            this.dropSelf((Block)registry.get());
        }
    }

    private LootTable.Builder createVariantTable(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FFPBlockstateProperties.VARIANT, 0)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FFPBlockstateProperties.VARIANT, 1)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FFPBlockstateProperties.VARIANT, 2)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FFPBlockstateProperties.VARIANT, 3)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return new ArrayList<Block>(){
            {
                this.addAll(FFPDecorBlockRegistry.BLOCKS.getEntries().stream().filter(blockDeferredHolder -> ((Block)blockDeferredHolder.get()).getLootTable() != BuiltInLootTables.EMPTY).map(e -> (Block)e.value()).toList());
                this.addAll(FFPPizzeriaBlocks.BLOCKS.getEntries().stream().filter(blockDeferredHolder -> ((Block)blockDeferredHolder.get()).getLootTable() != BuiltInLootTables.EMPTY).map(e -> (Block)e.value()).toList());
                this.addAll(FFPBlockRegistry.BLOCKS.getEntries().stream().filter(blockDeferredHolder -> ((Block)blockDeferredHolder.get()).getLootTable() != BuiltInLootTables.EMPTY).map(e -> (Block)e.value()).toList());
            }
        };
    }
}

