/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.BalloonBlock;
import net.mudhut.ffpackage.level.block.BigDoorBlock;
import net.mudhut.ffpackage.level.block.CardboardBoxBlock;
import net.mudhut.ffpackage.level.block.CardboardCutoutBlock;
import net.mudhut.ffpackage.level.block.ClothTableBlock;
import net.mudhut.ffpackage.level.block.CurtainBlock;
import net.mudhut.ffpackage.level.block.EntranceDoorBlock;
import net.mudhut.ffpackage.level.block.FluorescentLampBlock;
import net.mudhut.ffpackage.level.block.MetalCabinetBlock;
import net.mudhut.ffpackage.level.block.PartyHatBlock;
import net.mudhut.ffpackage.level.block.PizzaBlock;
import net.mudhut.ffpackage.level.block.SewingTableBlock;
import net.mudhut.ffpackage.level.block.ShowtapeTerminalBlock;
import net.mudhut.ffpackage.level.block.TomatoBushBlock;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FFPBlockStateProvider
extends BlockStateProvider {
    public FFPBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ffpackage", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder registry : FFPBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof MetalCabinetBlock || registry.get() instanceof TomatoBushBlock || registry.is(FFPBlockRegistry.ASSEMBLY_STAND) || registry.get() instanceof PizzaBlock || registry.get() instanceof ShowtapeTerminalBlock || registry.get() instanceof SewingTableBlock) continue;
            this.blockWithItem((DeferredHolder<Block, ? extends Block>)registry);
        }
        for (DeferredHolder registry : FFPPizzeriaBlocks.BLOCKS.getEntries()) {
            if (registry.get() instanceof StairBlock || registry.get() instanceof BigDoorBlock || registry.get() instanceof EntranceDoorBlock || registry.get() instanceof SlabBlock || registry.get() instanceof FluorescentLampBlock || registry.get() instanceof CardboardBoxBlock || registry.get() instanceof MetalCabinetBlock || registry.is(FFPPizzeriaBlocks.BLACK_STAGE) || registry.is(FFPPizzeriaBlocks.BLACK_CHECKER_TRIM) || registry.is(FFPPizzeriaBlocks.RED_CHECKER_TRIM) || registry.is(FFPPizzeriaBlocks.BUNDLED_CARDBOARD) || registry.is(FFPPizzeriaBlocks.CARDBOARD_TRAPDOOR)) continue;
            if (registry.get() instanceof CurtainBlock) {
                this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)registry, false);
                continue;
            }
            if (registry.get() instanceof RedstoneLampBlock) {
                this.lampBlock((DeferredHolder<Block, ? extends Block>)registry);
                continue;
            }
            if (registry.get() instanceof RotatedPillarBlock) {
                this.pillarBlock((DeferredHolder<Block, ? extends Block>)registry);
                continue;
            }
            this.blockWithItem((DeferredHolder<Block, ? extends Block>)registry);
        }
        for (DeferredHolder registry : FFPDecorBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof PartyHatBlock) {
                this.crossBlock((DeferredHolder<Block, ? extends Block>)registry);
                continue;
            }
            if (registry.get() instanceof CardboardCutoutBlock) {
                this.existingModelBlock((DeferredHolder<Block, ? extends Block>)registry, false);
                continue;
            }
            if (registry.get() instanceof ClothTableBlock) {
                this.tableBlock((DeferredHolder<Block, ? extends Block>)registry, true);
                continue;
            }
            if (!(registry.get() instanceof BalloonBlock)) continue;
            this.balloonBlock((DeferredHolder<Block, ? extends Block>)registry);
        }
        this.poweredHorizontalBlock((DeferredHolder<Block, ? extends Block>)FFPBlockRegistry.SEWING_TABLE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.WHITE_METAL_CABINET, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_METAL_CABINET, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.FREDDY_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.BONNIE_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.CHICA_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.FOXY_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.MR_CUPCAKE_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.FREDBEAR_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.SPRINGBONNIE_PLUSHIE, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.FREDDY_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.BONNIE_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.CHICA_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.FOXY_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.CELEBRATE_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.PARTY_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.RULES_POSTER, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.STARRED_BLACK_CHAIR, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.HANGING_STARS, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.STARS_CHAIN, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.WOOD_CLOUD_CHAIN, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.WOOD_SUN, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.WOOD_CLOUD, false);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.STAGE_SPEAKER, true);
        this.poweredHorizontalBlock((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.SODA_STAND, true);
        this.horizontalBlockWithItem((DeferredHolder<Block, ? extends Block>)FFPDecorBlockRegistry.MM_MACHINE, true);
        this.poweredHorizontalBlock((DeferredHolder<Block, ? extends Block>)FFPBlockRegistry.SHOWTAPE_TERMINAL, true);
        this.trapdoorBlock((TrapDoorBlock)FFPPizzeriaBlocks.CARDBOARD_TRAPDOOR.get(), FFPackage.resource("block/cardboard_block"), true);
        this.sidedBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_STAGE, FFPackage.resource("block/black_stage_side"), FFPackage.resource("block/black_stage_top"), FFPackage.resource("block/black_stage_top"));
        this.sidedBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_CHECKER_TRIM, FFPackage.resource("block/black_checker_trim"), FFPackage.resource("block/concrete"), FFPackage.resource("block/concrete"));
        this.sidedBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_CHECKER_TRIM, FFPackage.resource("block/red_checker_trim"), FFPackage.resource("block/concrete"), FFPackage.resource("block/concrete"));
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CARDBOARD_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CARDBOARD_BLOCK);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CARDBOARD_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CARDBOARD_BLOCK);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.WHITE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.WHITE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.WHITE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.WHITE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_WHITE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_WHITE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_WHITE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLACK_WHITE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_BLACK_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_BLACK_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_BLACK_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_BLACK_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_WHITE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_WHITE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_WHITE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BLUE_WHITE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_BLACK_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_BLACK_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_BLACK_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_BLACK_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_WHITE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_WHITE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_WHITE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.GREEN_WHITE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLACK_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLACK_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLACK_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLACK_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_WHITE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_WHITE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_WHITE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_WHITE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLUE_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLUE_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLUE_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.RED_BLUE_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.YELLOW_GRAY_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.YELLOW_GRAY_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.YELLOW_GRAY_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.YELLOW_GRAY_TILES);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CONCRETE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CONCRETE);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CONCRETE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.CONCRETE);
        this.stairBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.MOSAIC_TILE_STAIRS, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.MOSAIC_TILES);
        this.slabBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.MOSAIC_TILE_SLAB, (DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.MOSAIC_TILES);
        this.sidedBlock((DeferredHolder<Block, ? extends Block>)FFPPizzeriaBlocks.BUNDLED_CARDBOARD, FFPackage.resource("block/bundled_cardboard_side"), FFPackage.resource("block/bundled_cardboard_top"), FFPackage.resource("block/bundled_cardboard_top"));
    }

    private void stairBlock(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> ogBlock) {
        this.stairsBlock((StairBlock)block.get(), FFPackage.resource("block/" + ogBlock.getId().getPath()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getId().getPath()), this.models().existingFileHelper));
    }

    private void sidedBlock(DeferredHolder<Block, ? extends Block> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)this.models().cubeBottomTop(block.getId().getPath(), side, bottom, top));
    }

    private void pillarBlock(DeferredHolder<Block, ? extends Block> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getId().getPath()), this.models().existingFileHelper));
    }

    private void slabBlock(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> ogBlock) {
        this.slabBlock((SlabBlock)block.get(), FFPackage.resource("block/" + ogBlock.getId().getPath()), FFPackage.resource("block/" + ogBlock.getId().getPath()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getId().getPath()), this.models().existingFileHelper));
    }

    private void horizontalBlockWithItem(DeferredHolder<Block, ? extends Block> blockRegistryObject, boolean hasBlockItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile model = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "")), this.models().existingFileHelper);
        this.horizontalBlock(block, (ModelFile)model);
        if (hasBlockItem) {
            this.simpleBlockItem(block, (ModelFile)model);
        }
    }

    private void tableBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject, boolean hasBlockItem) {
        Block block = (Block)blockRegistryObject.get();
        BlockModelBuilder baseModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", ""), "ffpackage:table_base")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        BlockModelBuilder cornerModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_corner", "ffpackage:table_base_corner")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        BlockModelBuilder edgeModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_edge", "ffpackage:table_base_edge")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        BlockModelBuilder endModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_end", "ffpackage:table_base_end")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        BlockModelBuilder middleModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_middle", "ffpackage:table_base_middle")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        BlockModelBuilder innerModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_inner", "ffpackage:table_base_inner")).texture("cloth", FFPackage.resource("block/cloth_table/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        this.getVariantBuilder(block).forAllStatesExcept(blockState -> {
            boolean isNorth = (Boolean)blockState.getValue((Property)ClothTableBlock.NORTH);
            boolean isEast = (Boolean)blockState.getValue((Property)ClothTableBlock.EAST);
            boolean isSouth = (Boolean)blockState.getValue((Property)ClothTableBlock.SOUTH);
            boolean isWest = (Boolean)blockState.getValue((Property)ClothTableBlock.WEST);
            BlockModelBuilder modelFile = baseModel;
            int yRot = 0;
            if (!isNorth && !isEast && !isSouth && isWest) {
                modelFile = endModel;
                yRot = 270;
            }
            if (!isNorth && !isEast && isSouth && !isWest) {
                modelFile = endModel;
                yRot = 180;
            }
            if (!isNorth && isEast && !isSouth && !isWest) {
                modelFile = endModel;
                yRot = 90;
            }
            if (isNorth && !isEast && !isSouth && !isWest) {
                modelFile = endModel;
                yRot = 0;
            }
            if (isNorth && !isEast && isSouth && !isWest) {
                modelFile = middleModel;
                yRot = 0;
            }
            if (!isNorth && isEast && !isSouth && isWest) {
                modelFile = middleModel;
                yRot = 90;
            }
            if (isNorth && isEast && isSouth && isWest) {
                modelFile = innerModel;
                yRot = 0;
            }
            if (!isNorth && !isEast && isSouth && isWest) {
                modelFile = cornerModel;
                yRot = 180;
            }
            if (isNorth && !isEast && !isSouth && isWest) {
                modelFile = cornerModel;
                yRot = 270;
            }
            if (!isNorth && isEast && isSouth && !isWest) {
                modelFile = cornerModel;
                yRot = 90;
            }
            if (isNorth && isEast && !isSouth && !isWest) {
                modelFile = cornerModel;
            }
            if (isNorth && !isEast && isSouth && isWest) {
                modelFile = edgeModel;
                yRot = 270;
            }
            if (!isNorth && isEast && isSouth && isWest) {
                modelFile = edgeModel;
                yRot = 180;
            }
            if (isNorth && isEast && isSouth && !isWest) {
                modelFile = edgeModel;
                yRot = 90;
            }
            if (isNorth && isEast && !isSouth && isWest) {
                modelFile = edgeModel;
                yRot = 0;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(yRot).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED});
        if (hasBlockItem) {
            this.simpleBlockItem(block, (ModelFile)baseModel);
        }
    }

    private void lampBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile litModel = this.cubeAll(block);
        ModelBuilder unlitModel = this.models().cubeAll("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_off", FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_off"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> FFPBlockStateProvider.lambda$lampBlock$1(litModel, (ModelFile)unlitModel, arg_0));
    }

    private void poweredHorizontalBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject, boolean hasBlockItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile poweredModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "")), this.models().existingFileHelper);
        ModelFile.ExistingModelFile unpoweredModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_on"), this.models().existingFileHelper);
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
            return ConfiguredModel.builder().modelFile((ModelFile)(powered ? unpoweredModel : poweredModel)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
        });
        if (hasBlockItem) {
            this.simpleBlockItem(block, (ModelFile)poweredModel);
        }
    }

    private void balloonBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile balloon1 = new ModelFile.ExistingModelFile(FFPackage.resource("block/balloon_1"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile balloon2 = new ModelFile.ExistingModelFile(FFPackage.resource("block/balloon_2"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile balloon3 = new ModelFile.ExistingModelFile(FFPackage.resource("block/balloon_3"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile balloon4 = new ModelFile.ExistingModelFile(FFPackage.resource("block/balloon_4"), this.models().existingFileHelper);
        ((BlockModelBuilder)this.models().withExistingParent("block/" + block.getDescriptionId().replace("block.ffpackage.", ""), "ffpackage:block/balloon_item")).texture("balloon", FFPackage.resource("block/balloon/" + block.getDescriptionId().replace("block.ffpackage.", "")));
        this.getVariantBuilder(block).forAllStates(state -> {
            int variant = (Integer)state.getValue((Property)FFPBlockstateProperties.VARIANT);
            Direction direction = (Direction)state.getValue((Property)BalloonBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)(variant == 0 ? balloon1 : (variant == 1 ? balloon2 : (variant == 2 ? balloon3 : balloon4)))).rotationY(((int)direction.toYRot() + 180) % 360).build();
        });
    }

    private void blockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlockWithItem((Block)block.get(), this.cubeAll((Block)block.get()));
    }

    private void existingModelBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject, boolean hasItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile modelFile = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "")), this.models().existingFileHelper);
        this.simpleBlock(block, (ModelFile)modelFile);
        if (hasItem) {
            this.simpleBlockItem(block, (ModelFile)modelFile);
        }
    }

    private void logRotationBlock(DeferredHolder<Block, ? extends Block> blockRegistryObject, boolean hasItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile vertModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_vertical"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile horiModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_horizontal"), this.models().existingFileHelper);
        this.axisBlock((RotatedPillarBlock)block, (ModelFile)vertModel, (ModelFile)horiModel);
        if (hasItem) {
            this.simpleBlockItem(block, (ModelFile)vertModel);
        }
    }

    private void crossBlock(DeferredHolder<Block, ? extends Block> block) {
        ModelBuilder cross = ((BlockModelBuilder)this.models().cross(block.getId().toString(), FFPackage.resource("block/" + ((Block)block.get()).getDescriptionId().replace("block.ffpackage.", "")))).renderType("minecraft:cutout");
        this.simpleBlock((Block)block.get(), (ModelFile)cross);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lampBlock$1(ModelFile litModel, ModelFile unlitModel, BlockState state) {
        boolean lit = (Boolean)state.getValue((Property)RedstoneTorchBlock.LIT);
        return ConfiguredModel.builder().modelFile(lit ? litModel : unlitModel).build();
    }
}

