/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.BalloonBlock;
import net.mudhut.ffpackage.level.block.PartyHatBlock;
import net.mudhut.ffpackage.level.item.FazWrenchItem;
import net.mudhut.ffpackage.level.item.FlashlightItem;
import net.mudhut.ffpackage.level.item.ScrewDriverItem;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class FFPItemModelProvider
extends ItemModelProvider {
    public FFPItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ffpackage", existingFileHelper);
    }

    protected void registerModels() {
        for (DeferredHolder registry : FFPItemRegistry.ITEMS.getEntries()) {
            if (registry.get() instanceof FazWrenchItem || registry.get() instanceof FlashlightItem || registry.get() instanceof ScrewDriverItem || registry.get() instanceof BlockItem || registry == FFPItemRegistry.CLASSIC_MR_CUPCAKE || registry == FFPItemRegistry.CLASSIC_GUITAR) continue;
            if (registry == FFPItemRegistry.CLASSIC_MICROPHONE) {
                this.handHeldItem(FFPItemRegistry.CLASSIC_MICROPHONE);
                continue;
            }
            try {
                this.simpleItem((DeferredItem<Item>)((DeferredItem)registry));
            }
            catch (Exception e) {
                this.placeholderItem((DeferredItem<Item>)((DeferredItem)registry));
            }
        }
        for (DeferredHolder registry : FFPDecorBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof PartyHatBlock) {
                this.blockItemWithTexture((DeferredBlock<Block>)((DeferredBlock)registry), FFPackage.resource("block/" + ((Block)registry.get()).getDescriptionId().replace("block.ffpackage.", "")));
            }
            if (!(registry.get() instanceof BalloonBlock)) continue;
            this.simpleBlockItem((Block)registry.get());
        }
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.CARDBOARD_BOX.get());
        this.simpleBlockItem((Block)FFPDecorBlockRegistry.BLACK_SCONCE.get());
        this.simpleBlockItem((Block)FFPBlockRegistry.ASSEMBLY_STAND.get());
        this.trapdoorItem(FFPPizzeriaBlocks.CARDBOARD_TRAPDOOR);
        this.simpleItem(FFPItemRegistry.TOMATO_SEEDS);
        this.simpleItem(FFPItemRegistry.MANGROVE_DOOR_ITEM);
        this.simpleItem(FFPItemRegistry.BIG_METALLIC_DOOR_ITEM);
        this.handHeldItem(FFPItemRegistry.SCREWDRIVER);
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.WHITE_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.LIGHT_GRAY_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.GRAY_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.BROWN_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.RED_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.ORANGE_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.YELLOW_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.LIME_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.GREEN_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.CYAN_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.LIGHT_BLUE_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.BLUE_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.PURPLE_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.MAGENTA_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.PINK_STAINED_REDSTONE_LAMP.get());
        this.simpleBlockItem((Block)FFPPizzeriaBlocks.FLUORESCENT_LAMP.get());
        this.blockItemWithTexture(FFPDecorBlockRegistry.WOOD_OLIVE_PIZZA, FFPackage.resource("block/wall_black_olive_pizza_top"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.WOOD_PEPPERONI_PIZZA, FFPackage.resource("block/wall_pepperoni_pizza_top"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.FREDDY_POSTER, FFPackage.resource("item/freddy_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.BONNIE_POSTER, FFPackage.resource("item/bonnie_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.CHICA_POSTER, FFPackage.resource("item/chica_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.FOXY_POSTER, FFPackage.resource("item/foxy_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.PARTY_POSTER, FFPackage.resource("item/party_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.CELEBRATE_POSTER, FFPackage.resource("item/celebrate_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.RULES_POSTER, FFPackage.resource("item/rules_poster"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.WALL_PAPERS, FFPackage.resource("item/wall_papers"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.CHILDRENS_DRAWINGS, FFPackage.resource("item/childrens_drawings"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.TRASH_PILE, FFPackage.resource("item/trash_pile"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.HANGING_STARS, FFPackage.resource("block/hanging_stars"));
        this.blockItemWithTexture(FFPBlockRegistry.COOKED_PEPPERONI_PIZZA, FFPackage.resource("item/cooked_pepperoni_pizza"));
        this.blockItemWithTexture(FFPBlockRegistry.COOKED_CHEESE_PIZZA, FFPackage.resource("item/cooked_cheese_pizza"));
        this.blockItemWithTexture(FFPBlockRegistry.COOKED_DRIED_KELP_PIZZA, FFPackage.resource("item/cooked_dried_kelp_pizza"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.WHITE_CURTAIN, FFPackage.resource("block/white_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_WHITE_CURTAIN, FFPackage.resource("block/starred_white_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.LIGHT_GRAY_CURTAIN, FFPackage.resource("block/light_gray_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_LIGHT_GRAY_CURTAIN, FFPackage.resource("block/starred_light_gray_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.GRAY_CURTAIN, FFPackage.resource("block/gray_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_GRAY_CURTAIN, FFPackage.resource("block/starred_gray_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.BLACK_CURTAIN, FFPackage.resource("block/black_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_BLACK_CURTAIN, FFPackage.resource("block/starred_black_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.BROWN_CURTAIN, FFPackage.resource("block/brown_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_BROWN_CURTAIN, FFPackage.resource("block/starred_brown_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.RED_CURTAIN, FFPackage.resource("block/red_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_RED_CURTAIN, FFPackage.resource("block/starred_red_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.ORANGE_CURTAIN, FFPackage.resource("block/orange_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_ORANGE_CURTAIN, FFPackage.resource("block/starred_orange_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.YELLOW_CURTAIN, FFPackage.resource("block/yellow_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_YELLOW_CURTAIN, FFPackage.resource("block/starred_yellow_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.LIME_CURTAIN, FFPackage.resource("block/lime_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_LIME_CURTAIN, FFPackage.resource("block/starred_lime_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.GREEN_CURTAIN, FFPackage.resource("block/green_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_GREEN_CURTAIN, FFPackage.resource("block/starred_green_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.CYAN_CURTAIN, FFPackage.resource("block/cyan_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_CYAN_CURTAIN, FFPackage.resource("block/starred_cyan_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.LIGHT_BLUE_CURTAIN, FFPackage.resource("block/light_blue_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_LIGHT_BLUE_CURTAIN, FFPackage.resource("block/starred_light_blue_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.BLUE_CURTAIN, FFPackage.resource("block/blue_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_BLUE_CURTAIN, FFPackage.resource("block/starred_blue_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.PURPLE_CURTAIN, FFPackage.resource("block/purple_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_PURPLE_CURTAIN, FFPackage.resource("block/starred_purple_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.MAGENTA_CURTAIN, FFPackage.resource("block/magenta_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_MAGENTA_CURTAIN, FFPackage.resource("block/starred_magenta_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.PINK_CURTAIN, FFPackage.resource("block/pink_curtain"));
        this.blockItemWithTexture(FFPPizzeriaBlocks.STARRED_PINK_CURTAIN, FFPackage.resource("block/starred_pink_curtain"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.WOOD_CLOUD, FFPackage.resource("item/wooden_cloud"));
        this.blockItemWithTexture(FFPDecorBlockRegistry.WOOD_SUN, FFPackage.resource("item/wooden_sun"));
    }

    private ItemModelBuilder simpleItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", FFPackage.resource("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder blockItemWithTexture(DeferredBlock<Block> block, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", texture);
    }

    private ItemModelBuilder handHeldItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", FFPackage.resource("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder placeholderItem(DeferredItem<Item> deferredItem) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(deferredItem.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.parse((String)"item/book"));
    }

    private ItemModelBuilder trapdoorItem(DeferredBlock<Block> deferredItem) {
        return (ItemModelBuilder)this.withExistingParent(deferredItem.getId().getPath(), FFPackage.resource("block/" + deferredItem.getId().getPath() + "_bottom"));
    }
}

