/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FFPSoundProvider
extends SoundDefinitionsProvider {
    protected FFPSoundProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "ffpackage", helper);
    }

    public void registerSounds() {
        for (DeferredHolder registry : FFPSoundRegistry.SOUND_EVENT.getEntries()) {
            if (registry.is(FFPSoundRegistry.ENDO_WALK) || registry.is(FFPSoundRegistry.PIZZA_BREAK) || registry.is(FFPSoundRegistry.PIZZA_PLACE) || registry.is(FFPSoundRegistry.PIZZA_STEP) || registry.is(FFPSoundRegistry.GRAB_SLICE) || registry.is(FFPSoundRegistry.FLASHLIGHT_CLICK) || registry.is(FFPSoundRegistry.BALLOON_BREAK) || registry.is(FFPSoundRegistry.BALLOON_PLACE) || registry.is(FFPSoundRegistry.SEWING_STAND_USE)) continue;
            this.addSound((DeferredHolder<SoundEvent, ? extends SoundEvent>)registry, this.create(registry.getId().getPath().replace(".", "/")));
        }
        this.addSound(FFPSoundRegistry.FLASHLIGHT_CLICK, this.create("item/flashlight/flashlight_click_1"), this.create("item/flashlight/flashlight_click_2"));
        this.addSound(FFPSoundRegistry.ENDO_WALK, this.create("entity/endo/endo_01_footstep_1"), this.create("entity/endo/endo_01_footstep_2"), this.create("entity/endo/endo_01_footstep_3"));
        this.addSound(FFPSoundRegistry.PIZZA_BREAK, this.create("block/pizza/pizza_break_1"), this.create("block/pizza/pizza_break_2"), this.create("block/pizza/pizza_break_3"));
        this.addSound(FFPSoundRegistry.PIZZA_PLACE, this.create("block/pizza/place_pizza_1"), this.create("block/pizza/place_pizza_2"));
        this.addSound(FFPSoundRegistry.PIZZA_STEP, this.create("block/pizza/pizza_step_1"), this.create("block/pizza/pizza_step_2"), this.create("block/pizza/pizza_step_3"), this.create("block/pizza/pizza_step_4"));
        this.addSound(FFPSoundRegistry.GRAB_SLICE, this.create("block/pizza/grab_slice_1"), this.create("block/pizza/grab_slice_2"), this.create("block/pizza/grab_slice_3"));
        this.addSound(FFPSoundRegistry.BALLOON_BREAK, this.create("block/balloon/balloon_break_1"), this.create("block/balloon/balloon_break_2"));
        this.addSound(FFPSoundRegistry.BALLOON_PLACE, this.create("block/balloon/balloon_place_1"), this.create("block/balloon/balloon_place_2"));
        this.addSound(FFPSoundRegistry.SEWING_STAND_USE, this.create("block/sewing_stand/sewing_stand_use_1"), this.create("block/sewing_stand/sewing_stand_use_2"), this.create("block/sewing_stand/sewing_stand_use_3"));
    }

    private void addSound(DeferredHolder<SoundEvent, ? extends SoundEvent> soundEvent, SoundDefinition.Sound ... sounds) {
        SoundDefinition definition = SoundDefinition.definition();
        definition.with(sounds);
        this.add(soundEvent.getId(), definition);
    }

    private SoundDefinition.Sound create(String path) {
        return FFPSoundProvider.sound((ResourceLocation)FFPackage.resource(path));
    }
}

