/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.client.renderer.CardboardCutoutItemRenderer;
import net.mudhut.ffpackage.client.renderer.VintageSpotlightItemRenderer;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemProperties;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.util.FFPArmPoses;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ffpackage", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FFPItemProperties.addItemProperties();
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return FFPArmPoses.CUPCAKE;
            }
        }, new Holder[]{FFPItemRegistry.CLASSIC_MR_CUPCAKE});
        event.registerItem(new IClientItemExtensions(){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return FFPArmPoses.CUPCAKE;
            }
        }, new Item[]{FFPDecorBlockRegistry.WHITE_BALLOON.asItem(), FFPDecorBlockRegistry.LIGHT_GRAY_BALLOON.asItem(), FFPDecorBlockRegistry.GRAY_BALLOON.asItem(), FFPDecorBlockRegistry.BLACK_BALLOON.asItem(), FFPDecorBlockRegistry.BROWN_BALLOON.asItem(), FFPDecorBlockRegistry.RED_BALLOON.asItem(), FFPDecorBlockRegistry.ORANGE_BALLOON.asItem(), FFPDecorBlockRegistry.YELLOW_BALLOON.asItem(), FFPDecorBlockRegistry.LIME_BALLOON.asItem(), FFPDecorBlockRegistry.GREEN_BALLOON.asItem(), FFPDecorBlockRegistry.CYAN_BALLOON.asItem(), FFPDecorBlockRegistry.LIGHT_BLUE_BALLOON.asItem(), FFPDecorBlockRegistry.BLUE_BALLOON.asItem(), FFPDecorBlockRegistry.PURPLE_BALLOON.asItem(), FFPDecorBlockRegistry.MAGENTA_BALLOON.asItem(), FFPDecorBlockRegistry.PINK_BALLOON.asItem()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new VintageSpotlightItemRenderer();
            }
        }, new Item[]{FFPDecorBlockRegistry.REDSTONE_SPOTLIGHT.asItem()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new CardboardCutoutItemRenderer();
            }
        }, new Item[]{FFPDecorBlockRegistry.BONNIE_CUTOUT.asItem(), FFPDecorBlockRegistry.FREDDY_CUTOUT.asItem(), FFPDecorBlockRegistry.CHICA_CUTOUT.asItem(), FFPDecorBlockRegistry.FOXY_CUTOUT.asItem()});
    }

    public static void registerSuit(RegisterClientExtensionsEvent event, Item head, Item torso, Item legs, final ModelLayerLocation modelLayerLocation) {
        event.registerItem(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(modelLayerLocation);
                return new HumanoidModel(part);
            }
        }, new Item[]{head});
        event.registerItem(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(modelLayerLocation);
                return new HumanoidModel(part);
            }
        }, new Item[]{torso});
        event.registerItem(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                ModelPart part = Minecraft.getInstance().getEntityModels().bakeLayer(modelLayerLocation);
                return new HumanoidModel(part);
            }
        }, new Item[]{legs});
    }
}

