/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.events;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.mudhut.ffpackage.client.gui.MidnightMotoristScreen;
import net.mudhut.ffpackage.client.gui.SewingTableScreen;
import net.mudhut.ffpackage.client.gui.ShowtapeTerminalScreen;
import net.mudhut.ffpackage.client.gui.SodaMachineConfigScreen;
import net.mudhut.ffpackage.client.gui.SodaMachineFillScreen;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPEntitiesRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.mudhut.ffpackage.registries.FFPRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

@EventBusSubscriber(modid="ffpackage", bus=EventBusSubscriber.Bus.MOD)
public class CommonModEvents {
    @SubscribeEvent
    public static void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)FFPEntitiesRegistry.ENDO_01.get(), Endo01.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        event.register(FFPRegistries.SUIT_REGISTRY);
        event.register(FFPRegistries.CATALOG_TABS);
        event.register(FFPRegistries.TAB_SHOPS);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(FFPMenuTypes.MIDNIGHT_MOTOR.get(), MidnightMotoristScreen::new);
        event.register(FFPMenuTypes.SODA_FILLER.get(), SodaMachineFillScreen::new);
        event.register(FFPMenuTypes.SODA_CONFIG.get(), SodaMachineConfigScreen::new);
        event.register(FFPMenuTypes.SHOWTAPE_TERMINAL.get(), ShowtapeTerminalScreen::new);
        event.register(FFPMenuTypes.SEWING_TABLE.get(), SewingTableScreen::new);
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(FFPItemRegistry.DAISY_BELL_DISC);
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            CommonModEvents.putAfter(Items.BEETROOT_SEEDS.getDefaultInstance(), FFPItemRegistry.TOMATO_SEEDS.toStack(), event);
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            CommonModEvents.putAfter(Items.DRIED_KELP.getDefaultInstance(), FFPItemRegistry.PEPPERONI.toStack(), event);
            CommonModEvents.putAfter(Items.PUMPKIN_PIE.getDefaultInstance(), FFPItemRegistry.UNCOOKED_PEPPERONI_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.UNCOOKED_PEPPERONI_PIZZA.toStack(), FFPBlockRegistry.COOKED_PEPPERONI_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPBlockRegistry.COOKED_PEPPERONI_PIZZA.toStack(), FFPItemRegistry.PEPPERONI_PIZZA_SLICE.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.PEPPERONI_PIZZA_SLICE.toStack(), FFPItemRegistry.UNCOOKED_CHEESE_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.UNCOOKED_CHEESE_PIZZA.toStack(), FFPBlockRegistry.COOKED_CHEESE_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPBlockRegistry.COOKED_CHEESE_PIZZA.toStack(), FFPItemRegistry.CHEESE_PIZZA_SLICE.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.CHEESE_PIZZA_SLICE.toStack(), FFPItemRegistry.UNCOOKED_DRIED_KELP_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.UNCOOKED_DRIED_KELP_PIZZA.toStack(), FFPBlockRegistry.COOKED_DRIED_KELP_PIZZA.toStack(), event);
            CommonModEvents.putAfter(FFPBlockRegistry.COOKED_DRIED_KELP_PIZZA.toStack(), FFPItemRegistry.DRIED_KELP_PIZZA_SLICE.toStack(), event);
            CommonModEvents.putAfter(Items.BEETROOT.getDefaultInstance(), FFPItemRegistry.TOMATO.toStack(), event);
            CommonModEvents.putAfter(Items.MILK_BUCKET.getDefaultInstance(), FFPItemRegistry.BUCKET_OF_CHEESE.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.BUCKET_OF_CHEESE.toStack(), FFPItemRegistry.EMPTY_CUP.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.EMPTY_CUP.toStack(), FFPItemRegistry.FIZZY_FAZ_CUP.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.FIZZY_FAZ_CUP.toStack(), FFPItemRegistry.CHICA_CHUG_CUP.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.CHICA_CHUG_CUP.toStack(), FFPItemRegistry.COVE_COOLER_CUP.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.COVE_COOLER_CUP.toStack(), FFPItemRegistry.EXOTIC_BEVERAGE_CUP.toStack(), event);
            CommonModEvents.putAfter(FFPItemRegistry.EXOTIC_BEVERAGE_CUP.toStack(), FFPItemRegistry.SODARONI_CUP.toStack(), event);
        }
        if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            CommonModEvents.putBefore(Blocks.WHITE_CONCRETE.asItem().getDefaultInstance(), FFPPizzeriaBlocks.CONCRETE.toStack(), event);
            CommonModEvents.putBefore(Blocks.WHITE_CONCRETE_POWDER.asItem().getDefaultInstance(), FFPPizzeriaBlocks.CONCRETE_POWDER.toStack(), event);
            CommonModEvents.putAfter(Blocks.PINK_GLAZED_TERRACOTTA.asItem().getDefaultInstance(), FFPPizzeriaBlocks.TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.WHITE_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.WHITE_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.LIGHT_GRAY_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.LIGHT_GRAY_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.GRAY_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.GRAY_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.BLACK_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.BLACK_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.BROWN_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.BROWN_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.RED_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.RED_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.ORANGE_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.ORANGE_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.YELLOW_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.YELLOW_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.LIME_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.LIME_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.GREEN_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.GREEN_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.CYAN_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.CYAN_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.LIGHT_BLUE_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.LIGHT_BLUE_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.BLUE_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.BLUE_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.PURPLE_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.PURPLE_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.MAGENTA_TERRACOTTA_PILLAR.toStack(), event);
            CommonModEvents.putAfter(FFPPizzeriaBlocks.MAGENTA_TERRACOTTA_PILLAR.toStack(), FFPPizzeriaBlocks.PINK_TERRACOTTA_PILLAR.toStack(), event);
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            CommonModEvents.putAfter(Blocks.CHISELED_TUFF.asItem().getDefaultInstance(), FFPPizzeriaBlocks.CUT_TUFF.toStack(), event);
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            CommonModEvents.putAfter(Items.EMERALD.getDefaultInstance(), FFPItemRegistry.RUBY.toStack(), event);
            CommonModEvents.putAfter(Items.WHEAT.getDefaultInstance(), FFPItemRegistry.DOUGH.toStack(), event);
        }
    }

    public static void putAfter(ItemStack existingItem, ItemStack newItem, BuildCreativeModeTabContentsEvent event) {
        event.insertAfter(existingItem, newItem, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public static void putBefore(ItemStack existingItem, ItemStack newItem, BuildCreativeModeTabContentsEvent event) {
        event.insertBefore(existingItem, newItem, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

