/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="ffpackage", bus=EventBusSubscriber.Bus.GAME)
public class CommonNeoEvents {
    @SubscribeEvent
    public static void entityDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)livingEntity;
            List entityClassList = villager.level().getEntitiesOfClass(LivingEntity.class, villager.getBoundingBox().inflate(45.0), entity -> {
                Endo01 endo01;
                return entity instanceof Endo01 && !(endo01 = (Endo01)((Object)entity)).isPossessed();
            });
            LivingEntity targetEntity = villager.level().getNearestEntity(entityClassList, TargetingConditions.DEFAULT, (LivingEntity)villager, villager.getX(), villager.getY(), villager.getZ());
            if (targetEntity instanceof Endo01) {
                Endo01 endo01 = (Endo01)targetEntity;
                endo01.setPossessed(true);
                endo01.possessTick = 20;
            }
        }
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.FARMER) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).add((entity, randomSource) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)FFPItemRegistry.TOMATO_SEEDS.get(), 5), 16, 1, 0.5f));
            ((List)trades.get(2)).add((entity, randomSource) -> new MerchantOffer(new ItemCost(FFPItemRegistry.TOMATO, 20), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.5f));
        }
    }
}

