/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.registries.FFPAdvancements;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import org.jetbrains.annotations.NotNull;

public class AssemblyStandBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final IntegerProperty ENDO_PARTS = FFPBlockstateProperties.ENDO_PARTS;
    public static final MapCodec<AssemblyStandBlock> CODEC = AssemblyStandBlock.simpleCodec(AssemblyStandBlock::new);

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public AssemblyStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? FFPVoxelShapes.ASSEMBLY_STAND_LOWER[((Direction)state.getValue((Property)FACING)).get2DDataValue()] : FFPVoxelShapes.ASSEMBLY_STAND_UPPER[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing.getAxis() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.getBlock() instanceof AssemblyStandBlock && facingState.getValue(HALF) != doubleblockhalf ? (BlockState)facingState.setValue(HALF, (Comparable)doubleblockhalf) : Blocks.AIR.defaultBlockState();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!(level.isClientSide || !player.isCreative() && player.hasCorrectToolForDrops(state, level, pos))) {
            DoublePlantBlock.preventDropFromBottomPart((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(blockpos).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            if (stack.is(FFPItemRegistry.ENDO_01_TORSO) && (Integer)state.getValue((Property)ENDO_PARTS) == 0) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(1)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(player, pos, SoundEvents.COPPER_BULB_PLACE, SoundSource.BLOCKS);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(FFPItemRegistry.ENDO_01_HEAD) && (Integer)state.getValue((Property)ENDO_PARTS) == 1) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(2)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(player, pos, SoundEvents.COPPER_BULB_PLACE, SoundSource.BLOCKS);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(FFPItemRegistry.ENDO_01_ARMS) && (Integer)state.getValue((Property)ENDO_PARTS) == 2) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(3)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(player, pos, SoundEvents.COPPER_BULB_PLACE, SoundSource.BLOCKS);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(FFPItemRegistry.ENDO_01_LEGS) && (Integer)state.getValue((Property)ENDO_PARTS) == 3) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(4)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(player, pos, SoundEvents.COPPER_BULB_PLACE, SoundSource.BLOCKS);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(FFPItemRegistry.SCREWDRIVER) && (Integer)state.getValue((Property)ENDO_PARTS) == 4) {
                RandomSource randomsource = RandomSource.create();
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ENDO_PARTS, (Comparable)Integer.valueOf(0)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ItemEntity itemEntity = (ItemEntity)EntityType.ITEM.create(level);
                itemEntity.setItem(FFPItemRegistry.ASSEMBLED_ENDO_01.toStack());
                itemEntity.setPos(pos.getCenter().add(0.0, -0.7, 0.0));
                itemEntity.setUnlimitedLifetime();
                itemEntity.setDeltaMovement(0.0, 0.2, 0.0);
                level.playSound(player, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.5f, randomsource.nextFloat());
                level.playSound(player, pos, (SoundEvent)FFPSoundRegistry.SCREWDRIVER_USE.get(), SoundSource.BLOCKS);
                level.addFreshEntity((Entity)itemEntity);
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
                FFPAdvancements.grant(player, FFPAdvancements.THE_JOY_OF_CREATION);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP) : blockstate.is((Block)this);
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, ENDO_PARTS, WATERLOGGED});
    }
}

