/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.DecorativeBlock;
import net.mudhut.ffpackage.level.block.entity.BalloonBlockEntity;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPTagsRegistry;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public class BalloonBlock
extends DecorativeBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty VARIANT = FFPBlockstateProperties.VARIANT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<DyeColor, DeferredBlock<Block>> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), p_29841_ -> {
        p_29841_.put(DyeColor.WHITE, FFPDecorBlockRegistry.WHITE_BALLOON);
        p_29841_.put(DyeColor.ORANGE, FFPDecorBlockRegistry.ORANGE_BALLOON);
        p_29841_.put(DyeColor.MAGENTA, FFPDecorBlockRegistry.MAGENTA_BALLOON);
        p_29841_.put(DyeColor.LIGHT_BLUE, FFPDecorBlockRegistry.LIGHT_BLUE_BALLOON);
        p_29841_.put(DyeColor.YELLOW, FFPDecorBlockRegistry.YELLOW_BALLOON);
        p_29841_.put(DyeColor.LIME, FFPDecorBlockRegistry.LIME_BALLOON);
        p_29841_.put(DyeColor.PINK, FFPDecorBlockRegistry.PINK_BALLOON);
        p_29841_.put(DyeColor.GRAY, FFPDecorBlockRegistry.GRAY_BALLOON);
        p_29841_.put(DyeColor.LIGHT_GRAY, FFPDecorBlockRegistry.LIGHT_GRAY_BALLOON);
        p_29841_.put(DyeColor.CYAN, FFPDecorBlockRegistry.CYAN_BALLOON);
        p_29841_.put(DyeColor.PURPLE, FFPDecorBlockRegistry.PURPLE_BALLOON);
        p_29841_.put(DyeColor.BLUE, FFPDecorBlockRegistry.BLUE_BALLOON);
        p_29841_.put(DyeColor.BROWN, FFPDecorBlockRegistry.BROWN_BALLOON);
        p_29841_.put(DyeColor.GREEN, FFPDecorBlockRegistry.GREEN_BALLOON);
        p_29841_.put(DyeColor.RED, FFPDecorBlockRegistry.RED_BALLOON);
        p_29841_.put(DyeColor.BLACK, FFPDecorBlockRegistry.BLACK_BALLOON);
    });
    public final DyeColor dyeColor;

    public BalloonBlock(DyeColor dyeColor, BlockBehaviour.Properties pProperties) {
        super(FFPVoxelShapes.GENERIC_16x, pProperties);
        this.dyeColor = dyeColor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(FFPTagsRegistry.BALLOON_ITEMS) && (Integer)state.getValue((Property)VARIANT) < 3 || super.canBeReplaced(state, useContext);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockState = pContext.getLevel().getBlockState(pContext.getClickedPos());
        BalloonBlockEntity balloonBlockEntity = (BalloonBlockEntity)pContext.getLevel().getBlockEntity(pContext.getClickedPos());
        if (blockState.is(FFPTagsRegistry.BALLOON_BLOCKS) && balloonBlockEntity != null) {
            switch ((Integer)blockState.getValue((Property)VARIANT)) {
                case 0: {
                    balloonBlockEntity.setColor(2, this.dyeColor);
                    break;
                }
                case 1: {
                    balloonBlockEntity.setColor(3, this.dyeColor);
                    break;
                }
                case 2: {
                    balloonBlockEntity.setColor(4, this.dyeColor);
                }
            }
            return (BlockState)blockState.setValue((Property)VARIANT, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockState.getValue((Property)VARIANT) + 1)));
        }
        ((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER));
        return super.getStateForPlacement(pContext);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BalloonBlockEntity balloonBlockEntity = (BalloonBlockEntity)level.getBlockEntity(pos);
        if (stack.is(Items.SHEARS) && balloonBlockEntity != null) {
            DyeColor balloonDyeColor = DyeColor.byId((int)balloonBlockEntity.getColor((Integer)state.getValue((Property)VARIANT) + 1));
            player.getInventory().add(new ItemStack((ItemLike)ITEM_BY_DYE.get(balloonDyeColor)));
            if ((Integer)state.getValue((Property)VARIANT) > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)VARIANT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)VARIANT) - 1)), 3);
            } else {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
            player.playSound(SoundEvents.SHEEP_SHEAR);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, VARIANT, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BalloonBlockEntity(blockPos, blockState);
    }
}

