/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.DirectionalBlock;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.refractionapi.refraction.helper.voxels.VoxelUtil;
import org.jetbrains.annotations.Nullable;

public class BigDoorBlock
extends DirectionalBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final IntegerProperty DOOR_PART = FFPBlockstateProperties.DOOR_PART;

    public BigDoorBlock(BlockBehaviour.Properties pProperties) {
        super(FFPVoxelShapes.GENERIC_16x, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)DOOR_PART, (Comparable)Integer.valueOf(3)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = (Integer)state.getValue((Property)DOOR_PART) <= 1 ? pos.below() : ((Integer)state.getValue((Property)DOOR_PART) == 2 || (Integer)state.getValue((Property)DOOR_PART) == 3 ? pos.below().below() : pos.below().below().below());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)level, pos) ? super.updateShape(state, direction, neighborState, level, pos, neighborPos) : Blocks.AIR.defaultBlockState();
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(context)) {
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)DOOR_PART, (Comparable)Integer.valueOf(3));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState collisionBlock = ((Block)FFPPizzeriaBlocks.BIG_METALLIC_DOOR.get()).defaultBlockState();
        if (state.getValue((Property)FACING) == Direction.SOUTH) {
            level.setBlock(pos.offset(0, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(5)), 3);
            level.setBlock(pos.offset(0, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(1)), 3);
            level.setBlock(pos.offset(1, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(4)), 3);
            level.setBlock(pos.offset(1, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(0)), 3);
            level.setBlock(pos.offset(1, 0, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(2)), 3);
        } else if (state.getValue((Property)FACING) == Direction.NORTH) {
            level.setBlock(pos.offset(0, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(5)), 3);
            level.setBlock(pos.offset(0, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(1)), 3);
            level.setBlock(pos.offset(-1, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(4)), 3);
            level.setBlock(pos.offset(-1, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(0)), 3);
            level.setBlock(pos.offset(-1, 0, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(2)), 3);
        } else if (state.getValue((Property)FACING) == Direction.EAST) {
            level.setBlock(pos.offset(0, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(5)), 3);
            level.setBlock(pos.offset(0, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(1)), 3);
            level.setBlock(pos.offset(0, 1, -1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(4)), 3);
            level.setBlock(pos.offset(0, -1, -1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(0)), 3);
            level.setBlock(pos.offset(0, 0, -1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(2)), 3);
        } else {
            level.setBlock(pos.offset(0, 1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(5)), 3);
            level.setBlock(pos.offset(0, -1, 0), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(1)), 3);
            level.setBlock(pos.offset(0, 1, 1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(4)), 3);
            level.setBlock(pos.offset(0, -1, 1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(0)), 3);
            level.setBlock(pos.offset(0, 0, 1), (BlockState)((BlockState)collisionBlock.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)FFPBlockstateProperties.DOOR_PART, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockState neighborState = level.getBlockState(neighborPos);
        if (neighborState.is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR) && neighborState.getValue((Property)FACING) == state.getValue((Property)FACING)) {
            if ((Integer)neighborState.getValue((Property)DOOR_PART) == 0 || (Integer)neighborState.getValue((Property)DOOR_PART) == 2 || (Integer)neighborState.getValue((Property)DOOR_PART) == 4) {
                if ((Integer)state.getValue((Property)DOOR_PART) == 0 || (Integer)state.getValue((Property)DOOR_PART) == 2 || (Integer)state.getValue((Property)DOOR_PART) == 4) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN))), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN))), 10);
                }
            } else if ((Integer)state.getValue((Property)DOOR_PART) == 1 || (Integer)state.getValue((Property)DOOR_PART) == 3 || (Integer)state.getValue((Property)DOOR_PART) == 5) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN))), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN))), 10);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 3);
        this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
        level.gameEvent((Entity)player, (Holder)(this.isOpen(state) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState neighborState = level.getBlockState(pos.offset(0, 1, 0));
        if (neighborState.is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(0, 1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(0, -1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, -1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(0, 2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, 2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(0, -2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, -2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(1, 0, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(1, 0, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-1, 0, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-1, 0, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(2, 0, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(2, 0, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-2, 0, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-2, 0, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if (neighborState.is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(0, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(1, 1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(1, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-1, 1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-1, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(2, 2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(2, 2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-2, 2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-2, 2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(1, -1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(1, -1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-1, -1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-1, -1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(2, -2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(2, -2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-2, -2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-2, -2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(2, 1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(2, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-1, 2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-1, 2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(1, 2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(1, 2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-2, 1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-2, 1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(2, -1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(2, -1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-1, -2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-1, -2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(1, -2, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(1, -2, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        if ((neighborState = level.getBlockState(pos.offset(-2, -1, 0))).is(FFPPizzeriaBlocks.BIG_METALLIC_DOOR)) {
            level.setBlock(pos.offset(-2, -1, 0), Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void setOpen(@javax.annotation.Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(entity, level, pos, open);
            level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
    }

    private void playSound(@javax.annotation.Nullable Entity source, Level level, BlockPos pos, boolean isOpening) {
        level.playSound(source, pos, isOpening ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (!((Boolean)blockState.getValue((Property)OPEN)).booleanValue()) {
            return VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
        }
        if ((Integer)blockState.getValue((Property)DOOR_PART) == 1 || (Integer)blockState.getValue((Property)DOOR_PART) == 3 || (Integer)blockState.getValue((Property)DOOR_PART) == 5) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        if ((Integer)blockState.getValue((Property)DOOR_PART) == 0 || (Integer)blockState.getValue((Property)DOOR_PART) == 2 || (Integer)blockState.getValue((Property)DOOR_PART) == 4) {
            return switch ((Direction)blockState.getValue((Property)FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                case Direction.NORTH -> VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
                case Direction.SOUTH -> VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
                case Direction.WEST -> VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
                case Direction.EAST -> VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
            };
        }
        return VoxelUtil.makeHorizontalShapes((VoxelShape)Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0))[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, DOOR_PART});
    }
}

