/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.entity.CardboardBoxBlockEntity;
import net.mudhut.ffpackage.level.item.components.CardboardBoxItemstackComponent;
import net.mudhut.ffpackage.registries.FFPBlockstateProperties;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalEntityBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlock
extends BaseHorizontalEntityBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty ITEM = FFPBlockstateProperties.ITEM;
    public static final ResourceLocation CONTENTS = FFPackage.resource("contents");

    public CardboardBoxBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ITEM, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return FFPVoxelShapes.GENERIC_16x[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            level.setBlock(pos, (BlockState)state.cycle((Property)OPEN), 3);
            level.playSound(player, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, 3);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        CardboardBoxBlockEntity cardboardBoxBlockEntity = (CardboardBoxBlockEntity)level.getLevel().getBlockEntity(pos);
        if (cardboardBoxBlockEntity != null) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ITEM, (Comparable)Boolean.valueOf(!cardboardBoxBlockEntity.getItemStack().isEmpty())), 3);
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CardboardBoxBlockEntity cardboardBoxBlockEntity = (CardboardBoxBlockEntity)level.getBlockEntity(pos);
        if (cardboardBoxBlockEntity == null) {
            return ItemInteractionResult.FAIL;
        }
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && !player.isCrouching()) {
            if (cardboardBoxBlockEntity.getItemStack().isEmpty() && !player.getMainHandItem().isEmpty() && !player.getMainHandItem().is(FFPPizzeriaBlocks.CARDBOARD_BOX.asItem())) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ITEM, (Comparable)Boolean.valueOf(true)), 3);
                if (!level.isClientSide) {
                    cardboardBoxBlockEntity.setItemStack(player.getMainHandItem());
                }
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                level.playSound(player, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS);
                level.sendBlockUpdated(pos, state, state, 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (!cardboardBoxBlockEntity.getItemStack().isEmpty()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ITEM, (Comparable)Boolean.valueOf(false)), 3);
                player.getInventory().add(cardboardBoxBlockEntity.getItemStack());
                if (!level.isClientSide) {
                    cardboardBoxBlockEntity.setItemStack(ItemStack.EMPTY);
                }
                level.playSound(player, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
                level.sendBlockUpdated(pos, state, state, 3);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        CardboardBoxBlockEntity cardboardBoxBlockEntity = (CardboardBoxBlockEntity)((Object)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY));
        if (cardboardBoxBlockEntity == null) {
            return List.of();
        }
        params = params.withDynamicDrop(CONTENTS, itemStackConsumer -> itemStackConsumer.accept(cardboardBoxBlockEntity.getItemStack()));
        return super.getDrops(state, params);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CardboardBoxItemstackComponent cardboardBoxItem = (CardboardBoxItemstackComponent)stack.get(FFPDataComponents.CARDBOARD_BOX_ITEM);
        if (cardboardBoxItem != null && !cardboardBoxItem.itemStack().isEmpty()) {
            String itemName = cardboardBoxItem.itemStack().getHoverName().getString();
            tooltipComponents.add((Component)Component.literal((String)"%s x%s".formatted(itemName, cardboardBoxItem.itemStack().getCount())).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, OPEN, ITEM});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CardboardBoxBlockEntity(blockPos, blockState);
    }
}

