/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.WallHangingDecorBlock;

public abstract class HangingBlock
extends WallHangingDecorBlock {
    public HangingBlock(VoxelShape[] voxelShapes, BlockBehaviour.Properties pProperties) {
        super(voxelShapes, false, pProperties);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.relative(Direction.UP)).isAir();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN.getOpposite() && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.DOWN && level.getBlockState(pos.relative(Direction.DOWN)).is((Block)this)) {
            return (BlockState)this.getChainBlock().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected abstract Block getChainBlock();
}

