/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.mudhut.ffpackage.level.block.DirectionalBlock;
import net.mudhut.ffpackage.level.block.entity.MetalCabinetBlockEntity;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import org.jetbrains.annotations.Nullable;

public class MetalCabinetBlock
extends DirectionalBlock
implements EntityBlock {
    public MetalCabinetBlock(BlockBehaviour.Properties properties) {
        super(FFPVoxelShapes.GENERIC_16x, properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof MetalCabinetBlockEntity) {
            player.openMenu((MenuProvider)((MetalCabinetBlockEntity)blockentity));
            player.awardStat(Stats.OPEN_CHEST);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof MetalCabinetBlockEntity) {
            ((MetalCabinetBlockEntity)blockentity).recheckOpen();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MetalCabinetBlockEntity(blockPos, blockState);
    }
}

