/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.entity.SodaStandBlockEntity;
import net.mudhut.ffpackage.util.FFPVoxelShapes;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalEntityBlock;
import org.jetbrains.annotations.Nullable;

public class SodaStandBlock
extends BaseHorizontalEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SodaStandBlock> CODEC = SodaStandBlock.simpleCodec(SodaStandBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public SodaStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean neighborHasSignal = level.hasNeighborSignal(pos);
        if (neighborHasSignal != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(neighborHasSignal)), 2);
        }
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        super.getStateForPlacement(ctx);
        Level levelaccessor = ctx.getLevel();
        BlockPos blockpos = ctx.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return FFPVoxelShapes.SODA_STAND[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof SodaStandBlockEntity) {
            SodaStandBlockEntity sodaMachineBlockEntity = (SodaStandBlockEntity)blockEntity;
            sodaMachineBlockEntity.drops();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity entity;
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide && (entity = level.getBlockEntity(pos)) instanceof SodaStandBlockEntity) {
            SodaStandBlockEntity sodaMachineEntity = (SodaStandBlockEntity)entity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)sodaMachineEntity, (Component)Component.empty()), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SodaStandBlockEntity(blockPos, blockState);
    }
}

